/*
 * Copyright 2024 NXP
 *
 * SPDX-License-Identifier: BSD-3-Clause
 */

/***********************************************************************************************************************
 * This file was generated by the MCUXpresso Config Tools. Any manual edits made to this file
 * will be overwritten if the respective MCUXpresso Config Tools is used to update this file.
 **********************************************************************************************************************/
/*
 * How to set up clock using clock driver functions:
 *
 * 1. Setup clock sources.
 *
 * 2. Set up all selectors to provide selected clocks.
 *
 * 3. Set up all dividers.
 */

/* clang-format off */
/* TEXT BELOW IS USED AS SETTING FOR TOOLS *************************************
!!GlobalInfo
product: Clocks v14.0
processor: MIMXRT798S
package_id: MIMXRT798SGFOA
mcu_data: ksdk2_0
processor_version: 0.2412.40
 * BE CAREFUL MODIFYING THIS COMMENT - IT IS YAML SETTINGS FOR TOOLS **********/
/* clang-format on */

#include "fsl_power.h"
#include "fsl_clock.h"
#include "clock_config.h"

/*******************************************************************************
 * Definitions
 ******************************************************************************/

/*******************************************************************************
 * Variables
 ******************************************************************************/

/*******************************************************************************
 ************************ BOARD_InitBootClocks function ************************
 ******************************************************************************/
void BOARD_InitBootClocks(void)
{
    BOARD_BootClockRUN();
}

/* clang-format off */
/* TEXT BELOW IS USED AS SETTING FOR TOOLS *************************************
!!Configuration
name: BOARD_BootClockRUN
called_from_default_init: true
outputs:
- {id: COMM2_CLKOUT.outFreq, value: 25 MHz}
- {id: COMMON_RAM_CLK.outFreq, value: 250 MHz}
- {id: COMMON_VDDN_CLK.outFreq, value: 192 MHz}
- {id: COMPUTE_MAIN_CLK.outFreq, value: 250 MHz}
- {id: MEDIA_MAIN_CLK.outFreq, value: 250 MHz}
- {id: MEDIA_VDDN_CLK.outFreq, value: 250 MHz}
- {id: SENSE_CLKOUT.outFreq, value: 33 MHz}
- {id: SENSE_MAIN_CLK.outFreq, value: 198 MHz}
- {id: SENSE_MAIN_CLK_1.outFreq, value: 198 MHz}
- {id: SENSE_RAM_CLK.outFreq, value: 198 MHz}
- {id: audio_pll_pfd1_vdd1_sense.outFreq, value: 399.36 MHz}
- {id: audio_pll_pfd1_vdd2_com.outFreq, value: 399.36 MHz}
- {id: audio_pll_pfd1_vdd2_comp.outFreq, value: 399.36 MHz}
- {id: audio_pll_pfd1_vdd2_dsp.outFreq, value: 399.36 MHz}
- {id: audio_pll_pfd1_vdd2_media.outFreq, value: 399.36 MHz}
- {id: audio_pll_pfd1_vddn_com.outFreq, value: 399.36 MHz}
- {id: audio_pll_pfd1_vddn_media.outFreq, value: 399.36 MHz}
- {id: audio_pll_pfd3_vdd1_sense.outFreq, value: 368.64 MHz}
- {id: audio_pll_pfd3_vdd2_com.outFreq, value: 368.64 MHz}
- {id: audio_pll_pfd3_vdd2_comp.outFreq, value: 368.64 MHz}
- {id: audio_pll_pfd3_vdd2_dsp.outFreq, value: 368.64 MHz}
- {id: audio_pll_pfd3_vdd2_media.outFreq, value: 368.64 MHz}
- {id: audio_pll_pfd3_vddn_com.outFreq, value: 368.64 MHz}
- {id: audio_pll_pfd3_vddn_media.outFreq, value: 368.64 MHz}
- {id: audio_pll_vco_vdd1_sense.outFreq, value: 532.48 MHz}
- {id: audio_pll_vco_vdd2_com.outFreq, value: 532.48 MHz}
- {id: audio_pll_vco_vdd2_comp.outFreq, value: 532.48 MHz}
- {id: audio_pll_vco_vdd2_dsp.outFreq, value: 532.48 MHz}
- {id: audio_pll_vco_vdd2_media.outFreq, value: 532.48 MHz}
- {id: audio_pll_vco_vddn_com.outFreq, value: 532.48 MHz}
- {id: audio_pll_vco_vddn_media.outFreq, value: 532.48 MHz}
- {id: baseclk_cmpt.outFreq, value: 192 MHz}
- {id: baseclk_com2.outFreq, value: 192 MHz}
- {id: baseclk_comn.outFreq, value: 192 MHz}
- {id: baseclk_dsp.outFreq, value: 192 MHz}
- {id: baseclk_md2.outFreq, value: 192 MHz}
- {id: baseclk_mdn.outFreq, value: 192 MHz}
- {id: baseclk_sense.outFreq, value: 66 MHz}
- {id: fro0_div2.outFreq, value: 125 MHz}
- {id: fro0_div3.outFreq, value: 250/3 MHz}
- {id: fro0_div6.outFreq, value: 125/3 MHz}
- {id: fro0_div8.outFreq, value: 31.25 MHz}
- {id: fro0_max_vdd1_sense.outFreq, value: 250 MHz}
- {id: fro0_max_vdd2_com.outFreq, value: 250 MHz}
- {id: fro0_max_vdd2_comp.outFreq, value: 250 MHz}
- {id: fro0_max_vdd2_dsp.outFreq, value: 250 MHz}
- {id: fro0_max_vdd2_media.outFreq, value: 250 MHz}
- {id: fro0_max_vddn_com.outFreq, value: 250 MHz}
- {id: fro0_max_vddn_media.outFreq, value: 250 MHz}
- {id: fro0_tuner_divided_clk.outFreq, value: 24 MHz}
- {id: fro1_div2.outFreq, value: 96 MHz}
- {id: fro1_div3.outFreq, value: 64 MHz}
- {id: fro1_div6.outFreq, value: 32 MHz}
- {id: fro1_div8.outFreq, value: 24 MHz}
- {id: fro1_max.outFreq, value: 192 MHz}
- {id: fro2_div2.outFreq, value: 99 MHz}
- {id: fro2_div3.outFreq, value: 66 MHz}
- {id: fro2_div6.outFreq, value: 33 MHz}
- {id: fro2_div8.outFreq, value: 24.75 MHz}
- {id: fro2_max_vdd1_sense.outFreq, value: 198 MHz}
- {id: fro2_max_vdd2_com.outFreq, value: 198 MHz}
- {id: fro2_max_vdd2_comp.outFreq, value: 198 MHz}
- {id: fro2_max_vdd2_dsp.outFreq, value: 198 MHz}
- {id: fro2_max_vdd2_media.outFreq, value: 198 MHz}
- {id: fro2_max_vddn_com.outFreq, value: 198 MHz}
- {id: fro2_max_vddn_media.outFreq, value: 198 MHz}
- {id: fro2_tuner_divided_clk.outFreq, value: 24 MHz}
- {id: lposc_1m.outFreq, value: 1 MHz}
- {id: main_pll_pfd0_vdd1_sense.outFreq, value: 9504/19 MHz}
- {id: main_pll_pfd0_vdd2_com.outFreq, value: 9504/19 MHz}
- {id: main_pll_pfd0_vdd2_comp.outFreq, value: 9504/19 MHz}
- {id: main_pll_pfd0_vdd2_dsp.outFreq, value: 9504/19 MHz}
- {id: main_pll_pfd0_vdd2_media.outFreq, value: 9504/19 MHz}
- {id: main_pll_pfd0_vddn_com.outFreq, value: 9504/19 MHz}
- {id: main_pll_pfd0_vddn_media.outFreq, value: 9504/19 MHz}
- {id: main_pll_pfd1_vdd1_sense.outFreq, value: 396 MHz}
- {id: main_pll_pfd1_vdd2_com.outFreq, value: 396 MHz}
- {id: main_pll_pfd1_vdd2_comp.outFreq, value: 396 MHz}
- {id: main_pll_pfd1_vdd2_dsp.outFreq, value: 396 MHz}
- {id: main_pll_pfd1_vdd2_media.outFreq, value: 396 MHz}
- {id: main_pll_pfd1_vddn_com.outFreq, value: 396 MHz}
- {id: main_pll_pfd1_vddn_media.outFreq, value: 396 MHz}
- {id: main_pll_pfd2_vdd1_sense.outFreq, value: 528 MHz}
- {id: main_pll_pfd2_vdd2_com.outFreq, value: 528 MHz}
- {id: main_pll_pfd2_vdd2_comp.outFreq, value: 528 MHz}
- {id: main_pll_pfd2_vdd2_dsp.outFreq, value: 528 MHz}
- {id: main_pll_pfd2_vdd2_media.outFreq, value: 528 MHz}
- {id: main_pll_pfd2_vddn_com.outFreq, value: 528 MHz}
- {id: main_pll_pfd2_vddn_media.outFreq, value: 528 MHz}
- {id: main_pll_pfd3_vdd1_sense.outFreq, value: 9504/19 MHz}
- {id: main_pll_pfd3_vdd2_com.outFreq, value: 9504/19 MHz}
- {id: main_pll_pfd3_vdd2_comp.outFreq, value: 9504/19 MHz}
- {id: main_pll_pfd3_vdd2_dsp.outFreq, value: 9504/19 MHz}
- {id: main_pll_pfd3_vdd2_media.outFreq, value: 9504/19 MHz}
- {id: main_pll_pfd3_vddn_com.outFreq, value: 9504/19 MHz}
- {id: main_pll_pfd3_vddn_media.outFreq, value: 9504/19 MHz}
- {id: osc_clk.outFreq, value: 24 MHz}
- {id: osc_clk_eusb.outFreq, value: 24 MHz}
- {id: osc_clk_usb.outFreq, value: 24 MHz}
- {id: wake32k_clk.outFreq, value: 976.5625 Hz}
settings:
- {id: AUDIO_VDD1_CLK_SEL_INIT_Config, value: custom}
- {id: AUDIO_VDD2_CLK_SEL_INIT_Config, value: custom}
- {id: ClockPostInitConfig, value: BOARD_ClockPostConfig}
- {id: ClockPreInitConfig, value: BOARD_ClockPreConfig}
- {id: FCCLK0_CLK_SEL_INIT_Config, value: custom}
- {id: FCCLK1_CLK_SEL_INIT_Config, value: custom}
- {id: FCCLK2_CLK_SEL_INIT_Config, value: custom}
- {id: FCCLK3_CLK_SEL_INIT_Config, value: custom}
- {id: FRO0_mode, value: ClosedLoop}
- {id: FRO1_INIT_Config, value: custom}
- {id: FRO2_CPU_Core_Config, value: cm33_core1}
- {id: FRO2_mode, value: OpenLoop}
- {id: LOW_FREQ_CLK_SEL_INIT_Config, value: custom}
- {id: OSC32KNP_INIT_Config, value: custom}
- {id: RTC_SS_INIT_Config, value: custom}
- {id: VDDN_COM_BASE_CLK_SEL_INIT_Config, value: runtime}
- {id: WAKE32K_CLK_SEL_INIT_Config, value: custom}
- {id: XTAL_OSC_CPU_Core_Config, value: both}
- {id: CLKCTL0.CLOCK_ROOT_COMM2_CLKOUT.DIV.scale, value: '10', locked: true}
- {id: CLKCTL0.CLOCK_ROOT_COMM2_CLKOUT.MUX.sel, value: FRO0.FRO_MAX_VDD2_COM_CLK}
- {id: CLKCTL0.CLOCK_ROOT_COMMON_RAM_CLK.DIV.scale, value: '1', locked: true}
- {id: CLKCTL0.CLOCK_ROOT_COMMON_RAM_CLK.MUX.sel, value: FRO0.FRO_MAX_VDD2_COM_CLK}
- {id: CLKCTL0.CLOCK_ROOT_COMPUTE_MAIN_CLK.DIV.scale, value: '1', locked: true}
- {id: CLKCTL0.CLOCK_ROOT_COMPUTE_MAIN_CLK.MUX.sel, value: FRO0.FRO_MAX_VDD2_COMP_CLK}
- {id: CLKCTL0.CLOCK_ROOT_COMPUTE_SYSTICK_FCLK.DIV.scale, value: '129'}
- {id: CLKCTL0.CLOCK_ROOT_I3C01_FCLK.DIV.scale, value: '129'}
- {id: CLKCTL0.CMPTBASECLKSEL.sel, value: FRO1.FRO_MAX_CLK}
- {id: CLKCTL0.DSPBASECLKSEL.sel, value: FRO1.FRO_MAX_CLK}
- {id: CLKCTL0.VDD2COMBASECLKSEL.sel, value: FRO1.FRO_MAX_CLK}
- {id: CLKCTL1.CLOCK_ROOT_I3C23_FCLK.DIV.scale, value: '129'}
- {id: CLKCTL1.CLOCK_ROOT_SENSE_SYSTICK_FCLK.DIV.scale, value: '129'}
- {id: CLKCTL1.SENSEBASECLKSEL.sel, value: FRO2.FRO_DIV3_CLK}
- {id: CLKCTL2.AUDIOPLL0CLKSEL.sel, value: CLKCTL2.SYSOSCBYPASS}
- {id: CLKCTL2.AUDIO_PLL0_PFD1_DIV.scale, value: '24', locked: true}
- {id: CLKCTL2.AUDIO_PLL0_PFD1_MUL.scale, value: '18', locked: true}
- {id: CLKCTL2.AUDIO_PLL0_PFD3_DIV.scale, value: '26', locked: true}
- {id: CLKCTL2.AUDIO_PLL0_PFD3_MUL.scale, value: '18', locked: true}
- {id: CLKCTL2.Audio_PLL0.denom, value: '27000', locked: true}
- {id: CLKCTL2.Audio_PLL0.num, value: '5040', locked: true}
- {id: CLKCTL2.CLOCK_ROOT_COMMON_VDDN_CLK.DIV.scale, value: '1', locked: true}
- {id: CLKCTL2.COMNBASECLKSEL.sel, value: FRO1.FRO_MAX_CLK}
- {id: CLKCTL2.MAINPLL0CLKSEL.sel, value: CLKCTL2.SYSOSCBYPASS}
- {id: CLKCTL2.MAIN_PLL0_PFD0_DIV.scale, value: '19', locked: true}
- {id: CLKCTL2.MAIN_PLL0_PFD0_MUL.scale, value: '18', locked: true}
- {id: CLKCTL2.MAIN_PLL0_PFD1_DIV.scale, value: '24', locked: true}
- {id: CLKCTL2.MAIN_PLL0_PFD1_MUL.scale, value: '18', locked: true}
- {id: CLKCTL2.MAIN_PLL0_PFD2_DIV.scale, value: '18', locked: true}
- {id: CLKCTL2.MAIN_PLL0_PFD2_MUL.scale, value: '18', locked: true}
- {id: CLKCTL2.MAIN_PLL0_PFD3_DIV.scale, value: '19', locked: true}
- {id: CLKCTL2.MAIN_PLL0_PFD3_MUL.scale, value: '18', locked: true}
- {id: CLKCTL2.Main_PLL0.denom, value: '1'}
- {id: CLKCTL2.Main_PLL0.num, value: '0'}
- {id: CLKCTL2_SYSOSCCTL0_LP_ENABLE_CFG, value: low_power}
- {id: CLKCTL3.CLOCK_ROOT_MICFIL_FCLK.DIV.scale, value: '129'}
- {id: CLKCTL3.CLOCK_ROOT_SDADC_FCLK.DIV.scale, value: '129'}
- {id: CLKCTL3.CLOCK_ROOT_SENSE_MAIN_CLK.DIV.scale, value: '1', locked: true}
- {id: CLKCTL3.CLOCK_ROOT_SENSE_MAIN_CLK.MUX.sel, value: FRO2.FRO_MAX_VDD1_SENSE_CLK}
- {id: CLKCTL3.CLOCK_ROOT_SENSE_RAM_CLK.DIV.scale, value: '1', locked: true}
- {id: CLKCTL3.CLOCK_ROOT_SENSE_RAM_CLK.MUX.sel, value: FRO2.FRO_MAX_VDD1_SENSE_CLK}
- {id: CLKCTL4.CLOCK_ROOT_MEDIA_MAIN_CLK.DIV.scale, value: '1', locked: true}
- {id: CLKCTL4.CLOCK_ROOT_MEDIA_MAIN_CLK.MUX.sel, value: FRO0.FRO_MAX_VDD2_MEDIA_CLK}
- {id: CLKCTL4.CLOCK_ROOT_MEDIA_VDDN_CLK.DIV.scale, value: '1', locked: true}
- {id: CLKCTL4.CLOCK_ROOT_MEDIA_VDDN_CLK.MUX.sel, value: FRO0.FRO_MAX_VDDN_MEDIA_CLK}
- {id: CLKCTL4.CLOCK_ROOT_eUSB_WAKE_CLK.MUX.sel, value: CLKCTL3.lposc_1m}
- {id: CLKCTL4.MD2BASECLKSEL.sel, value: FRO1.FRO_MAX_CLK}
- {id: CLKCTL4.MDNBASECLKSEL.sel, value: FRO1.FRO_MAX_CLK}
- {id: CLKCTL4_FCCLK0_SEL_EN_CFG, value: Disabled}
- {id: CLKCTL4_FCCLK1_SEL_EN_CFG, value: Disabled}
- {id: CLKCTL4_FCCLK2_SEL_EN_CFG, value: Disabled}
- {id: CLKCTL4_FCCLK3_SEL_EN_CFG, value: Disabled}
- {id: CLKCTL4_LOWFREQCLKDIV_HALT_CFG, value: Enabled}
- {id: CLK_ROOT_COMM2_CLKOUT_INIT_Config, value: runtime}
- {id: CLK_ROOT_COMPUTE_SYSTICK_FCLK_INIT_Config, value: custom}
- {id: CLK_ROOT_COMPUTE_TPIU_CLK_INIT_Config, value: custom}
- {id: CLK_ROOT_CTIMER0_FCLK_INIT_Config, value: custom}
- {id: CLK_ROOT_CTIMER1_FCLK_INIT_Config, value: custom}
- {id: CLK_ROOT_CTIMER2_FCLK_INIT_Config, value: custom}
- {id: CLK_ROOT_CTIMER3_FCLK_INIT_Config, value: custom}
- {id: CLK_ROOT_CTIMER4_FCLK_INIT_Config, value: custom}
- {id: CLK_ROOT_CTIMER5_FCLK_INIT_Config, value: custom}
- {id: CLK_ROOT_CTIMER6_FCLK_INIT_Config, value: custom}
- {id: CLK_ROOT_CTIMER7_FCLK_INIT_Config, value: custom}
- {id: CLK_ROOT_DCPIXEL_FCLK_INIT_Config, value: custom}
- {id: CLK_ROOT_DPHY_BIT_CLK_INIT_Config, value: custom}
- {id: CLK_ROOT_DPHY_RX_CLK_INIT_Config, value: custom}
- {id: CLK_ROOT_DSP_CLK_INIT_Config, value: custom}
- {id: CLK_ROOT_FLEXCOMM0_FCLK_INIT_Config, value: custom}
- {id: CLK_ROOT_FLEXCOMM10_FCLK_INIT_Config, value: custom}
- {id: CLK_ROOT_FLEXCOMM11_FCLK_INIT_Config, value: custom}
- {id: CLK_ROOT_FLEXCOMM12_FCLK_INIT_Config, value: custom}
- {id: CLK_ROOT_FLEXCOMM13_FCLK_INIT_Config, value: custom}
- {id: CLK_ROOT_FLEXCOMM17_FCLK_INIT_Config, value: custom}
- {id: CLK_ROOT_FLEXCOMM18_FCLK_INIT_Config, value: custom}
- {id: CLK_ROOT_FLEXCOMM19_FCLK_INIT_Config, value: custom}
- {id: CLK_ROOT_FLEXCOMM1_FCLK_INIT_Config, value: custom}
- {id: CLK_ROOT_FLEXCOMM20_FCLK_INIT_Config, value: custom}
- {id: CLK_ROOT_FLEXCOMM2_FCLK_INIT_Config, value: custom}
- {id: CLK_ROOT_FLEXCOMM3_FCLK_INIT_Config, value: custom}
- {id: CLK_ROOT_FLEXCOMM4_FCLK_INIT_Config, value: custom}
- {id: CLK_ROOT_FLEXCOMM5_FCLK_INIT_Config, value: custom}
- {id: CLK_ROOT_FLEXCOMM6_FCLK_INIT_Config, value: custom}
- {id: CLK_ROOT_FLEXCOMM7_FCLK_INIT_Config, value: custom}
- {id: CLK_ROOT_FLEXCOMM8_FCLK_INIT_Config, value: custom}
- {id: CLK_ROOT_FLEXCOMM9_FCLK_INIT_Config, value: custom}
- {id: CLK_ROOT_FLEXIO_CLK_INIT_Config, value: custom}
- {id: CLK_ROOT_GPU_FCLK_INIT_Config, value: custom}
- {id: CLK_ROOT_I3C01_FCLK_INIT_Config, value: custom}
- {id: CLK_ROOT_I3C01_PCLK_INIT_Config, value: custom}
- {id: CLK_ROOT_I3C23_FCLK_INIT_Config, value: custom}
- {id: CLK_ROOT_LPI2C_FCLK_INIT_Config, value: custom}
- {id: CLK_ROOT_LPSPI14_FCLK_INIT_Config, value: custom}
- {id: CLK_ROOT_LPSPI16_FCLK_INIT_Config, value: custom}
- {id: CLK_ROOT_MICFIL_FCLK_INIT_Config, value: custom}
- {id: CLK_ROOT_OSEVENT_FCLK_INIT_Config, value: custom}
- {id: CLK_ROOT_SAI012_CLK_INIT_Config, value: custom}
- {id: CLK_ROOT_SAI3_CLK_INIT_Config, value: custom}
- {id: CLK_ROOT_SARADC_FCLK_INIT_Config, value: custom}
- {id: CLK_ROOT_SCT_FCLK_INIT_Config, value: custom}
- {id: CLK_ROOT_SDADC_FCLK_INIT_Config, value: custom}
- {id: CLK_ROOT_SDIO0_FCLK_INIT_Config, value: custom}
- {id: CLK_ROOT_SDIO1_FCLK_INIT_Config, value: custom}
- {id: CLK_ROOT_SENSE_CLKOUT_CPU_Core_Config, value: cm33_core1}
- {id: CLK_ROOT_SENSE_CLKOUT_INIT_Config, value: runtime}
- {id: CLK_ROOT_SENSE_DSP_CLK_INIT_Config, value: custom}
- {id: CLK_ROOT_SENSE_MAIN_CLK_CPU_Core_Config, value: cm33_core1}
- {id: CLK_ROOT_SENSE_RAM_CLK_CPU_Core_Config, value: cm33_core1}
- {id: CLK_ROOT_SENSE_SYSTICK_FCLK_INIT_Config, value: custom}
- {id: CLK_ROOT_USB_WAKE_CLK_INIT_Config, value: custom}
- {id: CLK_ROOT_UTICK0_FCLK_INIT_Config, value: custom}
- {id: CLK_ROOT_UTICK1_CLK_INIT_Config, value: custom}
- {id: CLK_ROOT_WDT0_FCLK_INIT_Config, value: custom}
- {id: CLK_ROOT_WDT1_FCLK_INIT_Config, value: custom}
- {id: CLK_ROOT_WDT2_FCLK_INIT_Config, value: custom}
- {id: CLK_ROOT_WDT3_FCLK_INIT_Config, value: custom}
- {id: CLK_ROOT_XSPI0_FCLK_INIT_Config, value: custom}
- {id: CLK_ROOT_XSPI1_FCLK_INIT_Config, value: custom}
- {id: CLK_ROOT_XSPI2_FCLK_INIT_Config, value: custom}
- {id: CLK_ROOT_eUSB_WAKE_CLK_INIT_Config, value: custom}
- {id: CLK_ROOT_osc_clk_eusb_INIT_Config, value: custom}
- {id: CLK_ROOT_osc_clk_usb_INIT_Config, value: custom}
- {id: CLOCK_ROOTCOMM2_CLKOUT_CONTROL_OFF_CFG, value: Enabled}
- {id: CLOCK_ROOTSENSE_CLKOUT_CONTROL_OFF_CFG, value: Enabled}
- {id: FRO0.FROMODESEL.sel, value: FRO0.FRO_TUNER}
- {id: FRO0_COARSE_TRIM_Config, value: Disabled}
- {id: FRO0_TRIM1_DELAY_US_Config, value: '15'}
- {id: FRO0_TRIM_COUNT_RANGE_Config, value: '100'}
- {id: FRO2_COARSE_TRIM_Config, value: Disabled}
- {id: FRO2_TRIM1_DELAY_US_Config, value: '15'}
- {id: FRO2_TRIM_COUNT_RANGE_Config, value: '100'}
sources:
- {id: CLKCTL2.XTAL_OSC.outFreq, value: 24 MHz, enabled: true}
- {id: FRO0.FRO_TUNER.outFreq, value: 250 MHz}
- {id: FRO2.FRO_TRIM.outFreq, value: 198 MHz}
- {id: FRO2.FRO_TUNER.outFreq, value: 198 MHz}
 * BE CAREFUL MODIFYING THIS COMMENT - IT IS YAML SETTINGS FOR TOOLS **********/
/* clang-format on */

const clock_fro_config_t g_fro0Config_BOARD_BootClockRUN =
    {
        .targetFreq = 250000000,                  /* FRO0 TUNER output clock frequency: 250000000Hz */
        .range = 100,                             /* FRO0 range value: ± 100counts */
        .trim1DelayUs = 15,                       /* FRO0 Trim1 delay: 15us */
        .trim2DelayUs = 150,                      /* FRO0 Trim2 delay: 150us */
        .refDiv = 1,                              /* The FRO reference divider is 1 */
        .enableInt = 0,                           /* The FRO interrupts are disabled */
        .coarseTrimEn = false,                    /* The coarse value autotrimming is disabled */
    };
const clock_main_pll_config_t g_mainPllConfigBOARD_BootClockRUN =
    {
        .main_pll_src = kCLOCK_MainPllOscClk,     /* XTAL OSC clock */
        .numerator = 0,                           /* Main PLL0 numerator value: 0 */
        .denominator = 1,                         /* Main PLL0 numerator value: 1 */
        .main_pll_mult = kCLOCK_MainPllMult22,    /* Divide by 22 */
    };
const clock_audio_pll_config_t g_audioPllConfigBOARD_BootClockRUN =
    {
        .audio_pll_src = kCLOCK_AudioPllOscClk,   /* XTAL OSC clock */
        .numerator = 5040,                        /* Audio PLL0 numerator value: 5040 */
        .denominator = 27000,                     /* Audio PLL0 numerator value: 27000 */
        .audio_pll_mult = kCLOCK_AudioPllMult22,  /* Divide by 22 */
        .enableVcoOut = true,                     /* The Audio PLL0 VCO clock output is enabled */
    };
/*******************************************************************************
 * Code for BOARD_BootClockRUN configuration
 ******************************************************************************/
void BOARD_BootClockRUN_InitClockModule(clock_module_t module)
{
    switch(module) {
        case kClockModule_FRO0:
            /* Enable power and ungate the FRO0. */
            POWER_DisablePD(kPDRUNCFG_GATE_FRO0);
            POWER_DisablePD(kPDRUNCFG_PD_FRO0);
            /* Configure FRO clock module in closed loop (autotrimming) mode */
            CLOCK_EnableFroClkFreqCloseLoop(FRO0, &g_fro0Config_BOARD_BootClockRUN, kCLOCK_FroDiv1OutEn | kCLOCK_FroDiv2OutEn | kCLOCK_FroDiv3OutEn | kCLOCK_FroDiv6OutEn | kCLOCK_FroDiv8OutEn);
            /* Setup domain specific clock gates */
            CLOCK_EnableFro0ClkForDomain(kCLOCK_VddnComDomainEnable | kCLOCK_Vdd2ComDomainEnable | kCLOCK_VddnMediaDomainEnable | kCLOCK_Vdd2MediaDomainEnable | kCLOCK_Vdd2DspDomainEnable | kCLOCK_Vdd1SenseDomainEnable | kCLOCK_Vdd2CompDomainEnable);
            break;
        case kClockModule_XTAL_OSC:
            /* Configure XTAL oscillator clock module */
            POWER_DisablePD(kPDRUNCFG_PD_SYSXTAL);
            CLOCK_EnableSysOscClk(true, true, 220); /* Enable system OSC */
            CLOCK_SetXtalFreq(BOARD_XTAL_SYS_CLK_HZ);                    /* Sets external XTAL OSC freq */
            break;
        case kClockModule_MAIN_PLL0:
            /* Configure Main PLL0 clock module */
            CLKCTL2->MAINPLL0CTL0 |= CLKCTL2_MAINPLL0CTL0_BYPASS_MASK; /* Bypass Main PLL0 and PFDs outputs */ 
            CLOCK_InitMainPll(&g_mainPllConfigBOARD_BootClockRUN);
            /* Main PLL0 PFD0 output value = Main PLL0 VCO * 18 / 19 */
            CLOCK_InitMainPfd(kCLOCK_Pfd0, 19U);
            CLOCK_EnableMainPllPfdClkForDomain(kCLOCK_Pfd0, kCLOCK_VddnComDomainEnable | kCLOCK_Vdd2ComDomainEnable | kCLOCK_VddnMediaDomainEnable | kCLOCK_Vdd2MediaDomainEnable | kCLOCK_Vdd2DspDomainEnable | kCLOCK_Vdd1SenseDomainEnable | kCLOCK_Vdd2CompDomainEnable);
            /* Main PLL0 PFD1 output value = Main PLL0 VCO * 18 / 24 */
            CLOCK_InitMainPfd(kCLOCK_Pfd1, 24U);
            CLOCK_EnableMainPllPfdClkForDomain(kCLOCK_Pfd1, kCLOCK_VddnComDomainEnable | kCLOCK_Vdd2ComDomainEnable | kCLOCK_VddnMediaDomainEnable | kCLOCK_Vdd2MediaDomainEnable | kCLOCK_Vdd2DspDomainEnable | kCLOCK_Vdd1SenseDomainEnable | kCLOCK_Vdd2CompDomainEnable);
            /* Main PLL0 PFD2 output value = Main PLL0 VCO * 18 / 18 */
            CLOCK_InitMainPfd(kCLOCK_Pfd2, 18U);
            CLOCK_EnableMainPllPfdClkForDomain(kCLOCK_Pfd2, kCLOCK_VddnComDomainEnable | kCLOCK_Vdd2ComDomainEnable | kCLOCK_VddnMediaDomainEnable | kCLOCK_Vdd2MediaDomainEnable | kCLOCK_Vdd2DspDomainEnable | kCLOCK_Vdd1SenseDomainEnable | kCLOCK_Vdd2CompDomainEnable);
            /* Main PLL0 PFD3 output value = Main PLL0 VCO * 18 / 19 */
            CLOCK_InitMainPfd(kCLOCK_Pfd3, 19U);
            CLOCK_EnableMainPllPfdClkForDomain(kCLOCK_Pfd3, kCLOCK_VddnComDomainEnable | kCLOCK_Vdd2ComDomainEnable | kCLOCK_VddnMediaDomainEnable | kCLOCK_Vdd2MediaDomainEnable | kCLOCK_Vdd2DspDomainEnable | kCLOCK_Vdd1SenseDomainEnable | kCLOCK_Vdd2CompDomainEnable);
            CLKCTL2->MAINPLL0CTL0 &= ~CLKCTL2_MAINPLL0CTL0_BYPASS_MASK; /* Disable bypass of the Main PLL0 and PFDs outputs */
            break;
        case kClockModule_AUDIO_PLL0:
            /* Configure Audio PLL0 clock module */
            CLKCTL2->AUDIOPLL0CTL0 |= CLKCTL2_AUDIOPLL0CTL0_BYPASS_MASK; /* Bypass Audio PLL0 and PFDs outputs */ 
            CLOCK_InitAudioPll(&g_audioPllConfigBOARD_BootClockRUN);
            /* Audio PLL0 PFD0 output value = Audio PLL0 VCO * 18 / 0 */
            CLOCK_InitAudioPfd(kCLOCK_Pfd0, 0U);
            CLOCK_EnableAudioPllPfdClkForDomain(kCLOCK_Pfd0, kCLOCK_VddnComDomainEnable | kCLOCK_Vdd2ComDomainEnable | kCLOCK_VddnMediaDomainEnable | kCLOCK_Vdd2MediaDomainEnable | kCLOCK_Vdd2DspDomainEnable | kCLOCK_Vdd1SenseDomainEnable | kCLOCK_Vdd2CompDomainEnable);
            /* Audio PLL0 PFD1 output value = Audio PLL0 VCO * 18 / 24 */
            CLOCK_InitAudioPfd(kCLOCK_Pfd1, 24U);
            CLOCK_EnableAudioPllPfdClkForDomain(kCLOCK_Pfd1, kCLOCK_VddnComDomainEnable | kCLOCK_Vdd2ComDomainEnable | kCLOCK_VddnMediaDomainEnable | kCLOCK_Vdd2MediaDomainEnable | kCLOCK_Vdd2DspDomainEnable | kCLOCK_Vdd1SenseDomainEnable | kCLOCK_Vdd2CompDomainEnable);
            /* Audio PLL0 PFD2 output value = Audio PLL0 VCO * 18 / 0 */
            CLOCK_InitAudioPfd(kCLOCK_Pfd2, 0U);
            CLOCK_EnableAudioPllPfdClkForDomain(kCLOCK_Pfd2, kCLOCK_VddnComDomainEnable | kCLOCK_Vdd2ComDomainEnable | kCLOCK_VddnMediaDomainEnable | kCLOCK_Vdd2MediaDomainEnable | kCLOCK_Vdd2DspDomainEnable | kCLOCK_Vdd1SenseDomainEnable | kCLOCK_Vdd2CompDomainEnable);
            /* Audio PLL0 PFD3 output value = Audio PLL0 VCO * 18 / 26 */
            CLOCK_InitAudioPfd(kCLOCK_Pfd3, 26U);
            CLOCK_EnableAudioPllPfdClkForDomain(kCLOCK_Pfd3, kCLOCK_VddnComDomainEnable | kCLOCK_Vdd2ComDomainEnable | kCLOCK_VddnMediaDomainEnable | kCLOCK_Vdd2MediaDomainEnable | kCLOCK_Vdd2DspDomainEnable | kCLOCK_Vdd1SenseDomainEnable | kCLOCK_Vdd2CompDomainEnable);
            /* Setup domain specific clock gates of the Audio PLL VCO output */
            CLOCK_EnableAudioPllVcoClkForDomain(kCLOCK_VddnComDomainEnable | kCLOCK_Vdd2ComDomainEnable | kCLOCK_VddnMediaDomainEnable | kCLOCK_Vdd2MediaDomainEnable | kCLOCK_Vdd2DspDomainEnable | kCLOCK_Vdd1SenseDomainEnable | kCLOCK_Vdd2CompDomainEnable);
            CLKCTL2->AUDIOPLL0CTL0 &= ~CLKCTL2_AUDIOPLL0CTL0_BYPASS_MASK; /* Disable bypass of the Audio PLL0 and PFDs outputs */
            break;
        case kClockModule_VDDN_COM_BASE_CLK_SEL:
            /* Switch COMMON_BASE to FRO1_DIV1 */
            CLOCK_AttachClk(kFRO1_DIV1_to_COMMON_BASE);
            break;
        case kClockModule_VDD2_COMP_BASE_CLK_SEL:
            /* Switch COMPUTE_BASE to FRO1_DIV1 */
            CLOCK_AttachClk(kFRO1_DIV1_to_COMPUTE_BASE);
            break;
        case kClockModule_VDD2_DSP_BASE_CLK_SEL:
            /* Switch DSP_BASE to FRO1_DIV1 */
            CLOCK_AttachClk(kFRO1_DIV1_to_DSP_BASE);
            break;
        case kClockModule_VDD2_COM_BASE_CLK_SEL:
            /* Switch COMMON_VDD2_BASE to FRO1_DIV1 */
            CLOCK_AttachClk(kFRO1_DIV1_to_COMMON_VDD2_BASE);
            break;
        case kClockModule_LPOSC_1M_CLK_SEL:
            POWER_DisablePD(kPDRUNCFG_PD_LPOSC); /* Enable the LPOSC 1 MHz*/
            break;
        case kClockModule_VDD2_MEDIA_BASE_CLK_SEL:
            /* Switch MEDIA_VDD2_BASE to FRO1_DIV1 */
            CLOCK_AttachClk(kFRO1_DIV1_to_MEDIA_VDD2_BASE);
            break;
        case kClockModule_VDDN_MEDIA_BASE_CLK_SEL:
            /* Switch MEDIA_VDDN_BASE to FRO1_DIV1 */
            CLOCK_AttachClk(kFRO1_DIV1_to_MEDIA_VDDN_BASE);
            break;
        case kClockModule_MEDIA_MAINCLK_SHUTOFF:
            POWER_DisablePD(kPDRUNCFG_SHUT_MEDIA_MAINCLK); /* Enable the media_main_clk and media_vddn_clk clocks. */
            break;
        case kClockModule_COMN_MAINCLK_SHUTOFF:
            POWER_DisablePD(kPDRUNCFG_SHUT_COMNN_MAINCLK); /* Enable the COMMON_VDDN_CLK clock. */
            break;
        case kClockModule_SENSES_MAINCLK_SHUTOFF:
            POWER_DisablePD(kPDRUNCFG_SHUT_SENSES_MAINCLK); /* Enable the SENSE_MAIN_CLK_1 clock. */
            break;
        case kClockModule_SENSEP_MAINCLK_SHUTOFF:
            POWER_DisablePD(kPDRUNCFG_SHUT_SENSEP_MAINCLK); /* Enable the SENSE_MAIN_CLK clock. */
            break;
        case kClockModule_COMP_MAINCLK_SHUTOFF:
            POWER_DisablePD(kPDRUNCFG_SHUT_COMPT_MAINCLK); /* Enable the COMPUTE_MAIN_CLK clock. */
            break;
        case kClockModule_CLK_ROOT_COMPUTE_MAIN_CLK:
            /* Set COMPUTE_MAIN_CLK divider to value 1 */
            CLOCK_SetClkDiv(kCLOCK_DivCmptMainClk, 1U);
            /* Switch COMPUTE_MAIN_CLK selector to FRO0.FRO_MAX_VDD2_COMP_CLK */
            CLOCK_AttachClk(kFRO0_DIV1_to_COMPUTE_MAIN);
            break;
        case kClockModule_CLK_ROOT_COMMON_RAM_CLK:
            /* Set COMMON_RAM_CLK divider to value 1 */
            CLOCK_SetClkDiv(kCLOCK_DivComputeRamClk, 1U);
            /* Switch COMMON_RAM_CLK selector to FRO0.FRO_MAX_VDD2_COM_CLK */
            CLOCK_AttachClk(kFRO0_DIV1_to_RAM);
            break;
        case kClockModule_CLK_ROOT_COMM2_CLKOUT:
            /* Switch COMM2_CLKOUT selector to FRO0.FRO_MAX_VDD2_COM_CLK */
            CLOCK_AttachClk(kFRO0_DIV1_to_VDD2_CLKOUT);
            /* Set COMM2_CLKOUT divider to value 10 */
            CLOCK_SetClkDiv(kCLOCK_DivClockOut, 10U);
            break;
        case kClockModule_CLK_ROOT_COMMON_VDDN_CLK:
            /* Set COMMON_VDDN_CLK divider to value 1 */
            CLOCK_SetClkDiv(kCLOCK_DivCommonVddnClk, 1U);
            /* Switch COMMON_VDDN_CLK selector to CLKCTL2.baseclk_comn */
            CLOCK_AttachClk(kCOMMON_BASE_to_COMMON_VDDN);
            break;
        case kClockModule_CLK_ROOT_MEDIA_VDDN_CLK:
            /* Set MEDIA_VDDN_CLK divider to value 1 */
            CLOCK_SetClkDiv(kCLOCK_DivMediaVddnClk, 1U);
            /* Switch MEDIA_VDDN_CLK selector to FRO0.FRO_MAX_VDDN_MEDIA_CLK */
            CLOCK_AttachClk(kFRO0_DIV1_to_MEDIA_VDDN);
            break;
        case kClockModule_CLK_ROOT_MEDIA_MAIN_CLK:
            /* Set MEDIA_MAIN_CLK divider to value 1 */
            CLOCK_SetClkDiv(kCLOCK_DivMediaMainClk, 1U);
            /* Switch MEDIA_MAIN_CLK selector to FRO0.FRO_MAX_VDD2_MEDIA_CLK */
            CLOCK_AttachClk(kFRO0_DIV1_to_MEDIA_MAIN);
            break;
        default:
            assert(false);
            break;
    }
}

void BOARD_BootClockRUN(void)
{
    BOARD_ClockPreConfig();
    BOARD_BootClockRUN_InitClockModule(kClockModule_XTAL_OSC);
    BOARD_BootClockRUN_InitClockModule(kClockModule_LPOSC_1M_CLK_SEL);
    BOARD_BootClockRUN_InitClockModule(kClockModule_FRO0);
    BOARD_BootClockRUN_InitClockModule(kClockModule_MAIN_PLL0);
    BOARD_BootClockRUN_InitClockModule(kClockModule_AUDIO_PLL0);
    BOARD_BootClockRUN_InitClockModule(kClockModule_VDD2_COMP_BASE_CLK_SEL);
    BOARD_BootClockRUN_InitClockModule(kClockModule_VDD2_DSP_BASE_CLK_SEL);
    BOARD_BootClockRUN_InitClockModule(kClockModule_VDD2_COM_BASE_CLK_SEL);
    BOARD_BootClockRUN_InitClockModule(kClockModule_VDD2_MEDIA_BASE_CLK_SEL);
    BOARD_BootClockRUN_InitClockModule(kClockModule_VDDN_MEDIA_BASE_CLK_SEL);
    BOARD_BootClockRUN_InitClockModule(kClockModule_CLK_ROOT_COMPUTE_MAIN_CLK);
    BOARD_BootClockRUN_InitClockModule(kClockModule_CLK_ROOT_COMMON_RAM_CLK);
    BOARD_BootClockRUN_InitClockModule(kClockModule_CLK_ROOT_COMMON_VDDN_CLK);
    BOARD_BootClockRUN_InitClockModule(kClockModule_CLK_ROOT_MEDIA_VDDN_CLK);
    BOARD_BootClockRUN_InitClockModule(kClockModule_CLK_ROOT_MEDIA_MAIN_CLK);
    BOARD_BootClockRUN_InitClockModule(kClockModule_MEDIA_MAINCLK_SHUTOFF);
    BOARD_BootClockRUN_InitClockModule(kClockModule_COMN_MAINCLK_SHUTOFF);
    BOARD_BootClockRUN_InitClockModule(kClockModule_SENSES_MAINCLK_SHUTOFF);
    BOARD_BootClockRUN_InitClockModule(kClockModule_SENSEP_MAINCLK_SHUTOFF);
    BOARD_BootClockRUN_InitClockModule(kClockModule_COMP_MAINCLK_SHUTOFF);
    BOARD_ClockPostConfig();
    /*!< Set SystemCoreClock variable. */
    SystemCoreClock = BOARD_BOOTCLOCKRUN_CORE_CLOCK;
}

/* clang-format off */
/* TEXT BELOW IS USED AS SETTING FOR TOOLS *************************************
!!Configuration
name: BOARD_BootClockHSRUN
outputs:
- {id: COMM2_CLKOUT.outFreq, value: 32.5 MHz}
- {id: COMMON_RAM_CLK.outFreq, value: 325 MHz}
- {id: COMMON_VDDN_CLK.outFreq, value: 192 MHz}
- {id: COMPUTE_MAIN_CLK.outFreq, value: 325 MHz}
- {id: MEDIA_MAIN_CLK.outFreq, value: 325 MHz}
- {id: MEDIA_VDDN_CLK.outFreq, value: 325 MHz}
- {id: SENSE_MAIN_CLK_1.outFreq, value: 250 MHz}
- {id: SENSE_RAM_CLK.outFreq, value: 250 MHz}
- {id: XSPI2_FCLK.outFreq, value: 96 MHz}
- {id: XSPI2_FCLK_DIV2.outFreq, value: 48 MHz}
- {id: audio_pll_pfd1_vdd1_sense.outFreq, value: 399.36 MHz}
- {id: audio_pll_pfd1_vdd2_com.outFreq, value: 399.36 MHz}
- {id: audio_pll_pfd1_vdd2_comp.outFreq, value: 399.36 MHz}
- {id: audio_pll_pfd1_vdd2_dsp.outFreq, value: 399.36 MHz}
- {id: audio_pll_pfd1_vddn_com.outFreq, value: 399.36 MHz}
- {id: audio_pll_pfd1_vddn_media.outFreq, value: 399.36 MHz}
- {id: audio_pll_pfd3_vdd1_sense.outFreq, value: 368.64 MHz}
- {id: audio_pll_pfd3_vdd2_com.outFreq, value: 368.64 MHz}
- {id: audio_pll_pfd3_vdd2_comp.outFreq, value: 368.64 MHz}
- {id: audio_pll_pfd3_vdd2_dsp.outFreq, value: 368.64 MHz}
- {id: audio_pll_pfd3_vdd2_media.outFreq, value: 368.64 MHz}
- {id: audio_pll_pfd3_vddn_com.outFreq, value: 368.64 MHz}
- {id: audio_pll_pfd3_vddn_media.outFreq, value: 368.64 MHz}
- {id: audio_pll_vco_vdd1_sense.outFreq, value: 532.48 MHz}
- {id: audio_pll_vco_vdd2_com.outFreq, value: 532.48 MHz}
- {id: audio_pll_vco_vdd2_comp.outFreq, value: 532.48 MHz}
- {id: audio_pll_vco_vdd2_dsp.outFreq, value: 532.48 MHz}
- {id: audio_pll_vco_vdd2_media.outFreq, value: 532.48 MHz}
- {id: audio_pll_vco_vddn_com.outFreq, value: 532.48 MHz}
- {id: audio_pll_vco_vddn_media.outFreq, value: 532.48 MHz}
- {id: baseclk_cmpt.outFreq, value: 192 MHz}
- {id: baseclk_com2.outFreq, value: 192 MHz}
- {id: baseclk_comn.outFreq, value: 192 MHz}
- {id: baseclk_dsp.outFreq, value: 192 MHz}
- {id: baseclk_md2.outFreq, value: 192 MHz}
- {id: baseclk_mdn.outFreq, value: 192 MHz}
- {id: baseclk_sense.outFreq, value: 64 MHz}
- {id: fro0_div2.outFreq, value: 162.5 MHz}
- {id: fro0_div3.outFreq, value: 325/3 MHz}
- {id: fro0_div6.outFreq, value: 162.5/3 MHz}
- {id: fro0_div8.outFreq, value: 81.25/2 MHz}
- {id: fro0_max_vdd1_sense.outFreq, value: 325 MHz}
- {id: fro0_max_vdd2_com.outFreq, value: 325 MHz}
- {id: fro0_max_vdd2_comp.outFreq, value: 325 MHz}
- {id: fro0_max_vdd2_dsp.outFreq, value: 325 MHz}
- {id: fro0_max_vdd2_media.outFreq, value: 325 MHz}
- {id: fro0_max_vddn_com.outFreq, value: 325 MHz}
- {id: fro0_max_vddn_media.outFreq, value: 325 MHz}
- {id: fro0_tuner_divided_clk.outFreq, value: 24 MHz}
- {id: fro1_div2.outFreq, value: 96 MHz}
- {id: fro1_div3.outFreq, value: 64 MHz}
- {id: fro1_div6.outFreq, value: 32 MHz}
- {id: fro1_div8.outFreq, value: 24 MHz}
- {id: fro1_max.outFreq, value: 192 MHz}
- {id: fro2_div2.outFreq, value: 125 MHz}
- {id: fro2_div3.outFreq, value: 250/3 MHz}
- {id: fro2_div6.outFreq, value: 125/3 MHz}
- {id: fro2_div8.outFreq, value: 31.25 MHz}
- {id: fro2_max_vdd1_sense.outFreq, value: 250 MHz}
- {id: fro2_max_vdd2_com.outFreq, value: 250 MHz}
- {id: fro2_max_vdd2_comp.outFreq, value: 250 MHz}
- {id: fro2_max_vdd2_dsp.outFreq, value: 250 MHz}
- {id: fro2_max_vdd2_media.outFreq, value: 250 MHz}
- {id: fro2_max_vddn_com.outFreq, value: 250 MHz}
- {id: fro2_max_vddn_media.outFreq, value: 250 MHz}
- {id: fro2_tuner_divided_clk.outFreq, value: 24 MHz}
- {id: lposc_1m.outFreq, value: 1 MHz}
- {id: main_pll_pfd0_vdd1_sense.outFreq, value: 9504/19 MHz}
- {id: main_pll_pfd0_vdd2_comp.outFreq, value: 9504/19 MHz}
- {id: main_pll_pfd0_vdd2_dsp.outFreq, value: 9504/19 MHz}
- {id: main_pll_pfd0_vdd2_media.outFreq, value: 9504/19 MHz}
- {id: main_pll_pfd0_vddn_com.outFreq, value: 9504/19 MHz}
- {id: main_pll_pfd0_vddn_media.outFreq, value: 9504/19 MHz}
- {id: main_pll_pfd1_vdd1_sense.outFreq, value: 396 MHz}
- {id: main_pll_pfd1_vdd2_com.outFreq, value: 396 MHz}
- {id: main_pll_pfd1_vdd2_comp.outFreq, value: 396 MHz}
- {id: main_pll_pfd1_vdd2_dsp.outFreq, value: 396 MHz}
- {id: main_pll_pfd1_vdd2_media.outFreq, value: 396 MHz}
- {id: main_pll_pfd1_vddn_com.outFreq, value: 396 MHz}
- {id: main_pll_pfd1_vddn_media.outFreq, value: 396 MHz}
- {id: main_pll_pfd2_vdd1_sense.outFreq, value: 528 MHz}
- {id: main_pll_pfd2_vdd2_com.outFreq, value: 528 MHz}
- {id: main_pll_pfd2_vdd2_comp.outFreq, value: 528 MHz}
- {id: main_pll_pfd2_vdd2_dsp.outFreq, value: 528 MHz}
- {id: main_pll_pfd2_vdd2_media.outFreq, value: 528 MHz}
- {id: main_pll_pfd2_vddn_com.outFreq, value: 528 MHz}
- {id: main_pll_pfd2_vddn_media.outFreq, value: 528 MHz}
- {id: main_pll_pfd3_vdd1_sense.outFreq, value: 9504/19 MHz}
- {id: main_pll_pfd3_vdd2_com.outFreq, value: 9504/19 MHz}
- {id: main_pll_pfd3_vdd2_comp.outFreq, value: 9504/19 MHz}
- {id: main_pll_pfd3_vdd2_dsp.outFreq, value: 9504/19 MHz}
- {id: main_pll_pfd3_vdd2_media.outFreq, value: 9504/19 MHz}
- {id: main_pll_pfd3_vddn_com.outFreq, value: 9504/19 MHz}
- {id: main_pll_pfd3_vddn_media.outFreq, value: 9504/19 MHz}
- {id: osc_clk.outFreq, value: 24 MHz}
- {id: osc_clk_eusb.outFreq, value: 24 MHz}
- {id: osc_clk_usb.outFreq, value: 24 MHz}
- {id: wake32k_clk.outFreq, value: 976.5625 Hz}
settings:
- {id: AUDIO_VDD1_CLK_SEL_INIT_Config, value: custom}
- {id: AUDIO_VDD2_CLK_SEL_INIT_Config, value: custom}
- {id: ClockPostInitConfig, value: BOARD_ClockHSRunPostConfig}
- {id: ClockPreInitConfig, value: BOARD_ClockHSRunPreConfig}
- {id: FCCLK0_CLK_SEL_INIT_Config, value: custom}
- {id: FCCLK1_CLK_SEL_INIT_Config, value: custom}
- {id: FCCLK2_CLK_SEL_INIT_Config, value: custom}
- {id: FCCLK3_CLK_SEL_INIT_Config, value: custom}
- {id: FRO0_mode, value: ClosedLoop}
- {id: FRO1_INIT_Config, value: custom}
- {id: FRO2_CPU_Core_Config, value: cm33_core1}
- {id: FRO2_mode, value: OpenLoop}
- {id: LOW_FREQ_CLK_SEL_INIT_Config, value: custom}
- {id: OSC32KNP_INIT_Config, value: custom}
- {id: RTC_SS_INIT_Config, value: custom}
- {id: SENSEP_MAINCLK_SHUTOFF_CPU_Core_Config, value: cm33_core1}
- {id: SENSEP_MAINCLK_SHUTOFF_Config, value: disabled}
- {id: SENSEP_MAINCLK_SHUTOFF_INIT_Config, value: custom}
- {id: WAKE32K_CLK_SEL_INIT_Config, value: custom}
- {id: CLKCTL0.CLOCK_ROOT_COMM2_CLKOUT.DIV.scale, value: '10', locked: true}
- {id: CLKCTL0.CLOCK_ROOT_COMM2_CLKOUT.MUX.sel, value: FRO0.FRO_MAX_VDD2_COM_CLK}
- {id: CLKCTL0.CLOCK_ROOT_COMMON_RAM_CLK.DIV.scale, value: '1', locked: true}
- {id: CLKCTL0.CLOCK_ROOT_COMMON_RAM_CLK.MUX.sel, value: FRO0.FRO_MAX_VDD2_COM_CLK}
- {id: CLKCTL0.CLOCK_ROOT_COMPUTE_MAIN_CLK.DIV.scale, value: '1', locked: true}
- {id: CLKCTL0.CLOCK_ROOT_COMPUTE_MAIN_CLK.MUX.sel, value: FRO0.FRO_MAX_VDD2_COMP_CLK}
- {id: CLKCTL0.CMPTBASECLKSEL.sel, value: FRO1.FRO_MAX_CLK}
- {id: CLKCTL0.DSPBASECLKSEL.sel, value: FRO1.FRO_MAX_CLK}
- {id: CLKCTL0.VDD2COMBASECLKSEL.sel, value: FRO1.FRO_MAX_CLK}
- {id: CLKCTL2.AUDIOPLL0CLKSEL.sel, value: CLKCTL2.SYSOSCBYPASS}
- {id: CLKCTL2.AUDIO_PLL0_PFD1_DIV.scale, value: '24', locked: true}
- {id: CLKCTL2.AUDIO_PLL0_PFD1_MUL.scale, value: '18', locked: true}
- {id: CLKCTL2.AUDIO_PLL0_PFD3_DIV.scale, value: '26', locked: true}
- {id: CLKCTL2.AUDIO_PLL0_PFD3_MUL.scale, value: '18', locked: true}
- {id: CLKCTL2.Audio_PLL0.denom, value: '27000'}
- {id: CLKCTL2.Audio_PLL0.num, value: '5040'}
- {id: CLKCTL2.CLOCK_ROOT_COMMON_VDDN_CLK.DIV.scale, value: '1', locked: true}
- {id: CLKCTL2.COMNBASECLKSEL.sel, value: FRO1.FRO_MAX_CLK}
- {id: CLKCTL2.MAINPLL0CLKSEL.sel, value: CLKCTL2.SYSOSCBYPASS}
- {id: CLKCTL2.MAIN_PLL0_PFD0_DIV.scale, value: '19', locked: true}
- {id: CLKCTL2.MAIN_PLL0_PFD0_MUL.scale, value: '18', locked: true}
- {id: CLKCTL2.MAIN_PLL0_PFD1_DIV.scale, value: '24', locked: true}
- {id: CLKCTL2.MAIN_PLL0_PFD1_MUL.scale, value: '18', locked: true}
- {id: CLKCTL2.MAIN_PLL0_PFD2_DIV.scale, value: '18', locked: true}
- {id: CLKCTL2.MAIN_PLL0_PFD2_MUL.scale, value: '18', locked: true}
- {id: CLKCTL2.MAIN_PLL0_PFD3_DIV.scale, value: '19', locked: true}
- {id: CLKCTL2.MAIN_PLL0_PFD3_MUL.scale, value: '18', locked: true}
- {id: CLKCTL2.Main_PLL0.denom, value: '1'}
- {id: CLKCTL2.Main_PLL0.num, value: '0'}
- {id: CLKCTL2_AUDIOPLL0PFDDOMAINEN_PFD1_OF_MD2_CFG, value: Disabled}
- {id: CLKCTL2_MAINPLL0PFDDOMAINEN_PFD0_OF_VDD2_COM_CFG, value: Disabled}
- {id: CLKCTL2_SYSOSCCTL0_LP_ENABLE_CFG, value: low_power}
- {id: CLKCTL3.CLOCK_ROOT_SENSE_MAIN_CLK.DIV.scale, value: '1', locked: true}
- {id: CLKCTL3.CLOCK_ROOT_SENSE_MAIN_CLK.MUX.sel, value: FRO2.FRO_MAX_VDD1_SENSE_CLK}
- {id: CLKCTL3.CLOCK_ROOT_SENSE_RAM_CLK.DIV.scale, value: '1', locked: true}
- {id: CLKCTL3.CLOCK_ROOT_SENSE_RAM_CLK.MUX.sel, value: FRO2.FRO_MAX_VDD1_SENSE_CLK}
- {id: CLKCTL4.CLOCK_ROOT_MEDIA_MAIN_CLK.DIV.scale, value: '1', locked: true}
- {id: CLKCTL4.CLOCK_ROOT_MEDIA_MAIN_CLK.MUX.sel, value: FRO0.FRO_MAX_VDD2_MEDIA_CLK}
- {id: CLKCTL4.CLOCK_ROOT_MEDIA_VDDN_CLK.DIV.scale, value: '1', locked: true}
- {id: CLKCTL4.CLOCK_ROOT_MEDIA_VDDN_CLK.MUX.sel, value: FRO0.FRO_MAX_VDDN_MEDIA_CLK}
- {id: CLKCTL4.MD2BASECLKSEL.sel, value: FRO1.FRO_MAX_CLK}
- {id: CLKCTL4.MDNBASECLKSEL.sel, value: FRO1.FRO_MAX_CLK}
- {id: CLK_ROOT_COMM2_CLKOUT_INIT_Config, value: runtime}
- {id: CLK_ROOT_COMPUTE_SYSTICK_FCLK_INIT_Config, value: custom}
- {id: CLK_ROOT_COMPUTE_TPIU_CLK_INIT_Config, value: custom}
- {id: CLK_ROOT_CTIMER0_FCLK_INIT_Config, value: custom}
- {id: CLK_ROOT_CTIMER1_FCLK_INIT_Config, value: custom}
- {id: CLK_ROOT_CTIMER2_FCLK_INIT_Config, value: custom}
- {id: CLK_ROOT_CTIMER3_FCLK_INIT_Config, value: custom}
- {id: CLK_ROOT_CTIMER4_FCLK_INIT_Config, value: custom}
- {id: CLK_ROOT_CTIMER5_FCLK_INIT_Config, value: custom}
- {id: CLK_ROOT_CTIMER6_FCLK_INIT_Config, value: custom}
- {id: CLK_ROOT_CTIMER7_FCLK_INIT_Config, value: custom}
- {id: CLK_ROOT_DCPIXEL_FCLK_INIT_Config, value: custom}
- {id: CLK_ROOT_DPHY_BIT_CLK_INIT_Config, value: custom}
- {id: CLK_ROOT_DPHY_RX_CLK_INIT_Config, value: custom}
- {id: CLK_ROOT_DSP_CLK_INIT_Config, value: custom}
- {id: CLK_ROOT_FLEXCOMM0_FCLK_INIT_Config, value: custom}
- {id: CLK_ROOT_FLEXCOMM10_FCLK_INIT_Config, value: custom}
- {id: CLK_ROOT_FLEXCOMM11_FCLK_INIT_Config, value: custom}
- {id: CLK_ROOT_FLEXCOMM12_FCLK_INIT_Config, value: custom}
- {id: CLK_ROOT_FLEXCOMM13_FCLK_INIT_Config, value: custom}
- {id: CLK_ROOT_FLEXCOMM17_FCLK_INIT_Config, value: custom}
- {id: CLK_ROOT_FLEXCOMM18_FCLK_INIT_Config, value: custom}
- {id: CLK_ROOT_FLEXCOMM19_FCLK_INIT_Config, value: custom}
- {id: CLK_ROOT_FLEXCOMM1_FCLK_INIT_Config, value: custom}
- {id: CLK_ROOT_FLEXCOMM20_FCLK_INIT_Config, value: custom}
- {id: CLK_ROOT_FLEXCOMM2_FCLK_INIT_Config, value: custom}
- {id: CLK_ROOT_FLEXCOMM3_FCLK_INIT_Config, value: custom}
- {id: CLK_ROOT_FLEXCOMM4_FCLK_INIT_Config, value: custom}
- {id: CLK_ROOT_FLEXCOMM5_FCLK_INIT_Config, value: custom}
- {id: CLK_ROOT_FLEXCOMM6_FCLK_INIT_Config, value: custom}
- {id: CLK_ROOT_FLEXCOMM7_FCLK_INIT_Config, value: custom}
- {id: CLK_ROOT_FLEXCOMM8_FCLK_INIT_Config, value: custom}
- {id: CLK_ROOT_FLEXCOMM9_FCLK_INIT_Config, value: custom}
- {id: CLK_ROOT_FLEXIO_CLK_INIT_Config, value: custom}
- {id: CLK_ROOT_GPU_FCLK_INIT_Config, value: custom}
- {id: CLK_ROOT_I3C01_FCLK_INIT_Config, value: custom}
- {id: CLK_ROOT_I3C01_PCLK_INIT_Config, value: custom}
- {id: CLK_ROOT_I3C23_FCLK_INIT_Config, value: custom}
- {id: CLK_ROOT_LPI2C_FCLK_INIT_Config, value: custom}
- {id: CLK_ROOT_LPSPI14_FCLK_INIT_Config, value: custom}
- {id: CLK_ROOT_LPSPI16_FCLK_INIT_Config, value: custom}
- {id: CLK_ROOT_MICFIL_FCLK_INIT_Config, value: custom}
- {id: CLK_ROOT_OSEVENT_FCLK_INIT_Config, value: custom}
- {id: CLK_ROOT_SAI012_CLK_INIT_Config, value: custom}
- {id: CLK_ROOT_SAI3_CLK_INIT_Config, value: custom}
- {id: CLK_ROOT_SARADC_FCLK_INIT_Config, value: custom}
- {id: CLK_ROOT_SCT_FCLK_INIT_Config, value: custom}
- {id: CLK_ROOT_SDADC_FCLK_INIT_Config, value: custom}
- {id: CLK_ROOT_SDIO0_FCLK_INIT_Config, value: custom}
- {id: CLK_ROOT_SDIO1_FCLK_INIT_Config, value: custom}
- {id: CLK_ROOT_SENSE_CLKOUT_INIT_Config, value: runtime}
- {id: CLK_ROOT_SENSE_DSP_CLK_INIT_Config, value: custom}
- {id: CLK_ROOT_SENSE_MAIN_CLK_CPU_Core_Config, value: cm33_core1}
- {id: CLK_ROOT_SENSE_RAM_CLK_CPU_Core_Config, value: cm33_core1}
- {id: CLK_ROOT_SENSE_SYSTICK_FCLK_INIT_Config, value: custom}
- {id: CLK_ROOT_USB_WAKE_CLK_INIT_Config, value: custom}
- {id: CLK_ROOT_UTICK0_FCLK_INIT_Config, value: custom}
- {id: CLK_ROOT_UTICK1_CLK_INIT_Config, value: custom}
- {id: CLK_ROOT_WDT0_FCLK_INIT_Config, value: custom}
- {id: CLK_ROOT_WDT1_FCLK_INIT_Config, value: custom}
- {id: CLK_ROOT_WDT2_FCLK_INIT_Config, value: custom}
- {id: CLK_ROOT_WDT3_FCLK_INIT_Config, value: custom}
- {id: CLK_ROOT_XSPI0_FCLK_INIT_Config, value: custom}
- {id: CLK_ROOT_XSPI1_FCLK_INIT_Config, value: custom}
- {id: CLK_ROOT_XSPI2_FCLK_INIT_Config, value: custom}
- {id: CLK_ROOT_eUSB_WAKE_CLK_INIT_Config, value: custom}
- {id: CLK_ROOT_osc_clk_eusb_INIT_Config, value: custom}
- {id: CLK_ROOT_osc_clk_usb_INIT_Config, value: custom}
- {id: CLOCK_ROOTCOMM2_CLKOUT_CONTROL_OFF_CFG, value: Enabled}
- {id: CLOCK_ROOTXSPI2_FCLK_CONTROL_OFF_CFG, value: Enabled}
- {id: FRO0.FROMODESEL.sel, value: FRO0.FRO_TUNER}
- {id: FRO0_COARSE_TRIM_Config, value: Disabled}
- {id: FRO0_TRIM_COUNT_RANGE_Config, value: '100'}
- {id: FRO2_COARSE_TRIM_Config, value: Disabled}
- {id: FRO2_TRIM_COUNT_RANGE_Config, value: '100'}
sources:
- {id: CLKCTL2.XTAL_OSC.outFreq, value: 24 MHz, enabled: true}
- {id: FRO0.FRO_TUNER.outFreq, value: 325 MHz}
- {id: FRO2.FRO_TRIM.outFreq, value: 250 MHz}
- {id: FRO2.FRO_TUNER.outFreq, value: 250 MHz}
 * BE CAREFUL MODIFYING THIS COMMENT - IT IS YAML SETTINGS FOR TOOLS **********/
/* clang-format on */

const clock_fro_config_t g_fro0Config_BOARD_BootClockHSRUN =
    {
        .targetFreq = 325000000,                  /* FRO0 TUNER output clock frequency: 325000000Hz */
        .range = 100,                             /* FRO0 range value: ± 100counts */
        .trim1DelayUs = 5,                        /* FRO0 Trim1 delay: 5us */
        .trim2DelayUs = 150,                      /* FRO0 Trim2 delay: 150us */
        .refDiv = 1,                              /* The FRO reference divider is 1 */
        .enableInt = 0,                           /* The FRO interrupts are disabled */
        .coarseTrimEn = false,                    /* The coarse value autotrimming is disabled */
    };
const clock_main_pll_config_t g_mainPllConfigBOARD_BootClockHSRUN =
    {
        .main_pll_src = kCLOCK_MainPllOscClk,     /* XTAL OSC clock */
        .numerator = 0,                           /* Main PLL0 numerator value: 0 */
        .denominator = 1,                         /* Main PLL0 numerator value: 1 */
        .main_pll_mult = kCLOCK_MainPllMult22,    /* Divide by 22 */
    };
const clock_audio_pll_config_t g_audioPllConfigBOARD_BootClockHSRUN =
    {
        .audio_pll_src = kCLOCK_AudioPllOscClk,   /* XTAL OSC clock */
        .numerator = 5040,                        /* Audio PLL0 numerator value: 5040 */
        .denominator = 27000,                     /* Audio PLL0 numerator value: 27000 */
        .audio_pll_mult = kCLOCK_AudioPllMult22,  /* Divide by 22 */
        .enableVcoOut = true,                     /* The Audio PLL0 VCO clock output is enabled */
    };
/*******************************************************************************
 * Code for BOARD_BootClockHSRUN configuration
 ******************************************************************************/
void BOARD_BootClockHSRUN_InitClockModule(clock_module_t module)
{
    switch(module) {
        case kClockModule_FRO0:
            /* Enable power and ungate the FRO0. */
            POWER_DisablePD(kPDRUNCFG_GATE_FRO0);
            POWER_DisablePD(kPDRUNCFG_PD_FRO0);
            /* Configure FRO clock module in closed loop (autotrimming) mode */
            CLOCK_EnableFroClkFreqCloseLoop(FRO0, &g_fro0Config_BOARD_BootClockHSRUN, kCLOCK_FroDiv1OutEn | kCLOCK_FroDiv2OutEn | kCLOCK_FroDiv3OutEn | kCLOCK_FroDiv6OutEn | kCLOCK_FroDiv8OutEn);
            /* Setup domain specific clock gates */
            CLOCK_EnableFro0ClkForDomain(kCLOCK_VddnComDomainEnable | kCLOCK_Vdd2ComDomainEnable | kCLOCK_VddnMediaDomainEnable | kCLOCK_Vdd2MediaDomainEnable | kCLOCK_Vdd2DspDomainEnable | kCLOCK_Vdd1SenseDomainEnable | kCLOCK_Vdd2CompDomainEnable);
            break;
        case kClockModule_XTAL_OSC:
            /* Configure XTAL oscillator clock module */
            POWER_DisablePD(kPDRUNCFG_PD_SYSXTAL);
            CLOCK_EnableSysOscClk(true, true, 220); /* Enable system OSC */
            CLOCK_SetXtalFreq(BOARD_XTAL_SYS_CLK_HZ);                    /* Sets external XTAL OSC freq */
            break;
        case kClockModule_MAIN_PLL0:
            /* Configure Main PLL0 clock module */
            CLKCTL2->MAINPLL0CTL0 |= CLKCTL2_MAINPLL0CTL0_BYPASS_MASK; /* Bypass Main PLL0 and PFDs outputs */ 
            CLOCK_InitMainPll(&g_mainPllConfigBOARD_BootClockHSRUN);
            /* Main PLL0 PFD0 output value = Main PLL0 VCO * 18 / 19 */
            CLOCK_InitMainPfd(kCLOCK_Pfd0, 19U);
            CLOCK_EnableMainPllPfdClkForDomain(kCLOCK_Pfd0, kCLOCK_VddnComDomainEnable | kCLOCK_VddnMediaDomainEnable | kCLOCK_Vdd2MediaDomainEnable | kCLOCK_Vdd2DspDomainEnable | kCLOCK_Vdd1SenseDomainEnable | kCLOCK_Vdd2CompDomainEnable);
            /* Main PLL0 PFD1 output value = Main PLL0 VCO * 18 / 24 */
            CLOCK_InitMainPfd(kCLOCK_Pfd1, 24U);
            CLOCK_EnableMainPllPfdClkForDomain(kCLOCK_Pfd1, kCLOCK_VddnComDomainEnable | kCLOCK_Vdd2ComDomainEnable | kCLOCK_VddnMediaDomainEnable | kCLOCK_Vdd2MediaDomainEnable | kCLOCK_Vdd2DspDomainEnable | kCLOCK_Vdd1SenseDomainEnable | kCLOCK_Vdd2CompDomainEnable);
            /* Main PLL0 PFD2 output value = Main PLL0 VCO * 18 / 18 */
            CLOCK_InitMainPfd(kCLOCK_Pfd2, 18U);
            CLOCK_EnableMainPllPfdClkForDomain(kCLOCK_Pfd2, kCLOCK_VddnComDomainEnable | kCLOCK_Vdd2ComDomainEnable | kCLOCK_VddnMediaDomainEnable | kCLOCK_Vdd2MediaDomainEnable | kCLOCK_Vdd2DspDomainEnable | kCLOCK_Vdd1SenseDomainEnable | kCLOCK_Vdd2CompDomainEnable);
            /* Main PLL0 PFD3 output value = Main PLL0 VCO * 18 / 19 */
            CLOCK_InitMainPfd(kCLOCK_Pfd3, 19U);
            CLOCK_EnableMainPllPfdClkForDomain(kCLOCK_Pfd3, kCLOCK_VddnComDomainEnable | kCLOCK_Vdd2ComDomainEnable | kCLOCK_VddnMediaDomainEnable | kCLOCK_Vdd2MediaDomainEnable | kCLOCK_Vdd2DspDomainEnable | kCLOCK_Vdd1SenseDomainEnable | kCLOCK_Vdd2CompDomainEnable);
            CLKCTL2->MAINPLL0CTL0 &= ~CLKCTL2_MAINPLL0CTL0_BYPASS_MASK; /* Disable bypass of the Main PLL0 and PFDs outputs */
            break;
        case kClockModule_AUDIO_PLL0:
            /* Configure Audio PLL0 clock module */
            CLKCTL2->AUDIOPLL0CTL0 |= CLKCTL2_AUDIOPLL0CTL0_BYPASS_MASK; /* Bypass Audio PLL0 and PFDs outputs */ 
            CLOCK_InitAudioPll(&g_audioPllConfigBOARD_BootClockHSRUN);
            /* Audio PLL0 PFD0 output value = Audio PLL0 VCO * 18 / 0 */
            CLOCK_InitAudioPfd(kCLOCK_Pfd0, 0U);
            CLOCK_EnableAudioPllPfdClkForDomain(kCLOCK_Pfd0, kCLOCK_VddnComDomainEnable | kCLOCK_Vdd2ComDomainEnable | kCLOCK_VddnMediaDomainEnable | kCLOCK_Vdd2MediaDomainEnable | kCLOCK_Vdd2DspDomainEnable | kCLOCK_Vdd1SenseDomainEnable | kCLOCK_Vdd2CompDomainEnable);
            /* Audio PLL0 PFD1 output value = Audio PLL0 VCO * 18 / 24 */
            CLOCK_InitAudioPfd(kCLOCK_Pfd1, 24U);
            CLOCK_EnableAudioPllPfdClkForDomain(kCLOCK_Pfd1, kCLOCK_VddnComDomainEnable | kCLOCK_Vdd2ComDomainEnable | kCLOCK_VddnMediaDomainEnable | kCLOCK_Vdd2DspDomainEnable | kCLOCK_Vdd1SenseDomainEnable | kCLOCK_Vdd2CompDomainEnable);
            /* Audio PLL0 PFD2 output value = Audio PLL0 VCO * 18 / 0 */
            CLOCK_InitAudioPfd(kCLOCK_Pfd2, 0U);
            CLOCK_EnableAudioPllPfdClkForDomain(kCLOCK_Pfd2, kCLOCK_VddnComDomainEnable | kCLOCK_Vdd2ComDomainEnable | kCLOCK_VddnMediaDomainEnable | kCLOCK_Vdd2MediaDomainEnable | kCLOCK_Vdd2DspDomainEnable | kCLOCK_Vdd1SenseDomainEnable | kCLOCK_Vdd2CompDomainEnable);
            /* Audio PLL0 PFD3 output value = Audio PLL0 VCO * 18 / 26 */
            CLOCK_InitAudioPfd(kCLOCK_Pfd3, 26U);
            CLOCK_EnableAudioPllPfdClkForDomain(kCLOCK_Pfd3, kCLOCK_VddnComDomainEnable | kCLOCK_Vdd2ComDomainEnable | kCLOCK_VddnMediaDomainEnable | kCLOCK_Vdd2MediaDomainEnable | kCLOCK_Vdd2DspDomainEnable | kCLOCK_Vdd1SenseDomainEnable | kCLOCK_Vdd2CompDomainEnable);
            /* Setup domain specific clock gates of the Audio PLL VCO output */
            CLOCK_EnableAudioPllVcoClkForDomain(kCLOCK_VddnComDomainEnable | kCLOCK_Vdd2ComDomainEnable | kCLOCK_VddnMediaDomainEnable | kCLOCK_Vdd2MediaDomainEnable | kCLOCK_Vdd2DspDomainEnable | kCLOCK_Vdd1SenseDomainEnable | kCLOCK_Vdd2CompDomainEnable);
            CLKCTL2->AUDIOPLL0CTL0 &= ~CLKCTL2_AUDIOPLL0CTL0_BYPASS_MASK; /* Disable bypass of the Audio PLL0 and PFDs outputs */
            break;
        case kClockModule_VDDN_COM_BASE_CLK_SEL:
            /* Switch COMMON_BASE to FRO1_DIV1 */
            CLOCK_AttachClk(kFRO1_DIV1_to_COMMON_BASE);
            break;
        case kClockModule_VDD2_COMP_BASE_CLK_SEL:
            /* Switch COMPUTE_BASE to FRO1_DIV1 */
            CLOCK_AttachClk(kFRO1_DIV1_to_COMPUTE_BASE);
            break;
        case kClockModule_VDD2_DSP_BASE_CLK_SEL:
            /* Switch DSP_BASE to FRO1_DIV1 */
            CLOCK_AttachClk(kFRO1_DIV1_to_DSP_BASE);
            break;
        case kClockModule_VDD2_COM_BASE_CLK_SEL:
            /* Switch COMMON_VDD2_BASE to FRO1_DIV1 */
            CLOCK_AttachClk(kFRO1_DIV1_to_COMMON_VDD2_BASE);
            break;
        case kClockModule_LPOSC_1M_CLK_SEL:
            POWER_DisablePD(kPDRUNCFG_PD_LPOSC); /* Enable the LPOSC 1 MHz*/
            break;
        case kClockModule_VDD2_MEDIA_BASE_CLK_SEL:
            /* Switch MEDIA_VDD2_BASE to FRO1_DIV1 */
            CLOCK_AttachClk(kFRO1_DIV1_to_MEDIA_VDD2_BASE);
            break;
        case kClockModule_VDDN_MEDIA_BASE_CLK_SEL:
            /* Switch MEDIA_VDDN_BASE to FRO1_DIV1 */
            CLOCK_AttachClk(kFRO1_DIV1_to_MEDIA_VDDN_BASE);
            break;
        case kClockModule_MEDIA_MAINCLK_SHUTOFF:
            POWER_DisablePD(kPDRUNCFG_SHUT_MEDIA_MAINCLK); /* Enable the media_main_clk and media_vddn_clk clocks. */
            break;
        case kClockModule_COMN_MAINCLK_SHUTOFF:
            POWER_DisablePD(kPDRUNCFG_SHUT_COMNN_MAINCLK); /* Enable the COMMON_VDDN_CLK clock. */
            break;
        case kClockModule_SENSES_MAINCLK_SHUTOFF:
            POWER_DisablePD(kPDRUNCFG_SHUT_SENSES_MAINCLK); /* Enable the SENSE_MAIN_CLK_1 clock. */
            break;
        case kClockModule_COMP_MAINCLK_SHUTOFF:
            POWER_DisablePD(kPDRUNCFG_SHUT_COMPT_MAINCLK); /* Enable the COMPUTE_MAIN_CLK clock. */
            break;
        case kClockModule_CLK_ROOT_COMPUTE_MAIN_CLK:
            /* Set COMPUTE_MAIN_CLK divider to value 1 */
            CLOCK_SetClkDiv(kCLOCK_DivCmptMainClk, 1U);
            /* Switch COMPUTE_MAIN_CLK selector to FRO0.FRO_MAX_VDD2_COMP_CLK */
            CLOCK_AttachClk(kFRO0_DIV1_to_COMPUTE_MAIN);
            break;
        case kClockModule_CLK_ROOT_COMMON_RAM_CLK:
            /* Set COMMON_RAM_CLK divider to value 1 */
            CLOCK_SetClkDiv(kCLOCK_DivComputeRamClk, 1U);
            /* Switch COMMON_RAM_CLK selector to FRO0.FRO_MAX_VDD2_COM_CLK */
            CLOCK_AttachClk(kFRO0_DIV1_to_RAM);
            break;
        case kClockModule_CLK_ROOT_COMM2_CLKOUT:
            /* Switch COMM2_CLKOUT selector to FRO0.FRO_MAX_VDD2_COM_CLK */
            CLOCK_AttachClk(kFRO0_DIV1_to_VDD2_CLKOUT);
            /* Set COMM2_CLKOUT divider to value 10 */
            CLOCK_SetClkDiv(kCLOCK_DivClockOut, 10U);
            break;
        case kClockModule_CLK_ROOT_COMMON_VDDN_CLK:
            /* Set COMMON_VDDN_CLK divider to value 1 */
            CLOCK_SetClkDiv(kCLOCK_DivCommonVddnClk, 1U);
            /* Switch COMMON_VDDN_CLK selector to CLKCTL2.baseclk_comn */
            CLOCK_AttachClk(kCOMMON_BASE_to_COMMON_VDDN);
            break;
        case kClockModule_CLK_ROOT_SENSE_CLKOUT:
            /* Switch SENSE_CLKOUT selector to off state. */
            CLOCK_AttachClk(kNONE_to_VDD1_CLKOUT);
            break;
        case kClockModule_CLK_ROOT_MEDIA_VDDN_CLK:
            /* Set MEDIA_VDDN_CLK divider to value 1 */
            CLOCK_SetClkDiv(kCLOCK_DivMediaVddnClk, 1U);
            /* Switch MEDIA_VDDN_CLK selector to FRO0.FRO_MAX_VDDN_MEDIA_CLK */
            CLOCK_AttachClk(kFRO0_DIV1_to_MEDIA_VDDN);
            break;
        case kClockModule_CLK_ROOT_MEDIA_MAIN_CLK:
            /* Set MEDIA_MAIN_CLK divider to value 1 */
            CLOCK_SetClkDiv(kCLOCK_DivMediaMainClk, 1U);
            /* Switch MEDIA_MAIN_CLK selector to FRO0.FRO_MAX_VDD2_MEDIA_CLK */
            CLOCK_AttachClk(kFRO0_DIV1_to_MEDIA_MAIN);
            break;
        default:
            assert(false);
            break;
    }
}

void BOARD_BootClockHSRUN(void)
{
    BOARD_ClockHSRunPreConfig();
    BOARD_BootClockHSRUN_InitClockModule(kClockModule_XTAL_OSC);
    BOARD_BootClockHSRUN_InitClockModule(kClockModule_LPOSC_1M_CLK_SEL);
    BOARD_BootClockHSRUN_InitClockModule(kClockModule_FRO0);
    BOARD_BootClockHSRUN_InitClockModule(kClockModule_MAIN_PLL0);
    BOARD_BootClockHSRUN_InitClockModule(kClockModule_AUDIO_PLL0);
    BOARD_BootClockHSRUN_InitClockModule(kClockModule_VDDN_COM_BASE_CLK_SEL);
    BOARD_BootClockHSRUN_InitClockModule(kClockModule_VDD2_COMP_BASE_CLK_SEL);
    BOARD_BootClockHSRUN_InitClockModule(kClockModule_VDD2_DSP_BASE_CLK_SEL);
    BOARD_BootClockHSRUN_InitClockModule(kClockModule_VDD2_COM_BASE_CLK_SEL);
    BOARD_BootClockHSRUN_InitClockModule(kClockModule_VDD2_MEDIA_BASE_CLK_SEL);
    BOARD_BootClockHSRUN_InitClockModule(kClockModule_VDDN_MEDIA_BASE_CLK_SEL);
    BOARD_BootClockHSRUN_InitClockModule(kClockModule_CLK_ROOT_COMPUTE_MAIN_CLK);
    BOARD_BootClockHSRUN_InitClockModule(kClockModule_CLK_ROOT_COMMON_RAM_CLK);
    BOARD_BootClockHSRUN_InitClockModule(kClockModule_CLK_ROOT_COMMON_VDDN_CLK);
    BOARD_BootClockHSRUN_InitClockModule(kClockModule_CLK_ROOT_MEDIA_VDDN_CLK);
    BOARD_BootClockHSRUN_InitClockModule(kClockModule_CLK_ROOT_MEDIA_MAIN_CLK);
    BOARD_BootClockHSRUN_InitClockModule(kClockModule_MEDIA_MAINCLK_SHUTOFF);
    BOARD_BootClockHSRUN_InitClockModule(kClockModule_COMN_MAINCLK_SHUTOFF);
    BOARD_BootClockHSRUN_InitClockModule(kClockModule_SENSES_MAINCLK_SHUTOFF);
    BOARD_BootClockHSRUN_InitClockModule(kClockModule_COMP_MAINCLK_SHUTOFF);
    BOARD_ClockHSRunPostConfig();
    /*!< Set SystemCoreClock variable. */
    SystemCoreClock = BOARD_BOOTCLOCKHSRUN_CORE_CLOCK;
}

