/*
 * Copyright 2024 NXP
 * All rights reserved.
 *
 * SPDX-License-Identifier: BSD-3-Clause
 */

/***********************************************************************************************************************
 * This file was generated by the MCUXpresso Config Tools. Any manual edits made to this file
 * will be overwritten if the respective MCUXpresso Config Tools is used to update this file.
 **********************************************************************************************************************/

/* clang-format off */
/*
 * TEXT BELOW IS USED AS SETTING FOR TOOLS *************************************
!!GlobalInfo
product: Pins v17.0
processor: MIMXRT798S
package_id: MIMXRT798SGFOA
mcu_data: ksdk2_0
processor_version: 0.2412.60
 * BE CAREFUL MODIFYING THIS COMMENT - IT IS YAML SETTINGS FOR TOOLS ***********
 */
/* clang-format on */

#include "fsl_common.h"
#include "fsl_iopctl.h"
#include "pin_mux.h"

/* FUNCTION ************************************************************************************************************
 *
 * Function Name : BOARD_InitBootPins
 * Description   : Calls initialization functions.
 *
 * END ****************************************************************************************************************/
void BOARD_InitBootPins(void)
{
    BOARD_InitPins();
}

/* clang-format off */
/*
 * TEXT BELOW IS USED AS SETTING FOR TOOLS *************************************
BOARD_InitPins:
- options: {callFromInitBoot: 'true', coreID: cm33_core0, enableClock: 'true'}
- pin_list:
  - {pin_num: N5, peripheral: LP_FLEXCOMM0, signal: P1, pin_signal: PIO1_0/LP_FLEXCOMM0_P1/SCT0_OUT9/CTIMER4_MAT1, selects_transmitter_current_drive: O_100}
  - {pin_num: N4, peripheral: LP_FLEXCOMM0, signal: P0, pin_signal: PIO0_31/LP_FLEXCOMM0_P0/UTICK0_CAP2/SCT0_OUT8/CTIMER4_MAT0, input_buffer: enable}
  - {pin_num: G12, peripheral: USDHC1, signal: USDHC_CARD_DET, pin_signal: PIO7_24/SDHC1_CARD_DET_N/LP_FLEXCOMM13_P4, selects_transmitter_current_drive: O_33, input_buffer: enable,
    pull_select: up, pull_enable: enable}
  - {pin_num: L17, peripheral: USDHC1, signal: USDHC_CLK, pin_signal: PIO7_17/SDHC1_CLK/LP_FLEXCOMM2_P0, selects_transmitter_current_drive: O_33, input_buffer: enable,
    pull_select: up, pull_enable: enable}
  - {pin_num: L16, peripheral: USDHC1, signal: USDHC_CMD, pin_signal: PIO7_18/SDHC1_CMD/LP_FLEXCOMM2_P1, selects_transmitter_current_drive: O_33, input_buffer: enable,
    pull_select: up, pull_enable: enable}
  - {pin_num: M17, peripheral: USDHC1, signal: 'USDHC_DATA, 0', pin_signal: PIO7_19/SDHC1_DATA0/LP_FLEXCOMM1_P4/LP_FLEXCOMM7_P3, selects_transmitter_current_drive: O_33,
    input_buffer: enable, pull_select: up, pull_enable: enable}
  - {pin_num: M18, peripheral: USDHC1, signal: 'USDHC_DATA, 1', pin_signal: PIO7_20/SDHC1_DATA1/LP_FLEXCOMM1_P5/LP_FLEXCOMM2_P4, selects_transmitter_current_drive: O_33,
    input_buffer: enable, pull_select: up, pull_enable: enable}
  - {pin_num: K18, peripheral: USDHC1, signal: 'USDHC_DATA, 2', pin_signal: PIO7_21/SDHC1_DATA2/LP_FLEXCOMM1_P6/LP_FLEXCOMM2_P5, selects_transmitter_current_drive: O_33,
    input_buffer: enable, pull_select: up, pull_enable: enable}
  - {pin_num: K17, peripheral: USDHC1, signal: 'USDHC_DATA, 3', pin_signal: PIO7_22/SDHC1_DATA3/LP_FLEXCOMM2_P2, selects_transmitter_current_drive: O_33, input_buffer: enable,
    pull_select: up, pull_enable: enable}
  - {pin_num: C5, peripheral: GPIO7, signal: 'GPIO, 11', pin_signal: PIO7_11/SDHC0_CARD_DET_N/LP_FLEXCOMM1_P1}
 * BE CAREFUL MODIFYING THIS COMMENT - IT IS YAML SETTINGS FOR TOOLS ***********
 */
/* clang-format on */

/* FUNCTION ************************************************************************************************************
 *
 * Function Name : BOARD_InitPins
 * Description   : Configures pin routing and optionally pin electrical features.
 *
 * END ****************************************************************************************************************/
/* Function assigned for the Cortex-M33 (Core #0) */
void BOARD_InitPins(void)
{
    /* Reset IOPCTL0 module */
    RESET_ClearPeripheralReset(kIOPCTL0_RST_SHIFT_RSTn);
    /* Reset IOPCTL2 module */
    RESET_ClearPeripheralReset(kIOPCTL2_RST_SHIFT_RSTn);

    const uint32_t port0_pin31_config = (/* Pin is configured as LP_FLEXCOMM0_P0 */
                                         IOPCTL_PIO_FUNC1 |
                                         /* Disable pull-up / pull-down function */
                                         IOPCTL_PIO_PUPD_DI |
                                         /* Enable pull-down function */
                                         IOPCTL_PIO_PULLDOWN_EN |
                                         /* Enables input buffer function */
                                         IOPCTL_PIO_INBUF_EN |
                                         /* Pseudo Output Drain is disabled */
                                         IOPCTL_PIO_PSEDRAIN_DI |
                                         /* Input function is not inverted */
                                         IOPCTL_PIO_INV_DI |
                                         /* Selects transmitter current drive 100ohm */
                                         IOPCTL_PIO_DRIVE_100OHM);
    /* PORT0 PIN31 (coords: N4) is configured as LP_FLEXCOMM0_P0 */
    IOPCTL_PinMuxSet(0U, 31U, port0_pin31_config);

    const uint32_t port1_pin0_config = (/* Pin is configured as LP_FLEXCOMM0_P1 */
                                        IOPCTL_PIO_FUNC1 |
                                        /* Disable pull-up / pull-down function */
                                        IOPCTL_PIO_PUPD_DI |
                                        /* Enable pull-down function */
                                        IOPCTL_PIO_PULLDOWN_EN |
                                        /* Disable input buffer function */
                                        IOPCTL_PIO_INBUF_DI |
                                        /* Pseudo Output Drain is disabled */
                                        IOPCTL_PIO_PSEDRAIN_DI |
                                        /* Input function is not inverted */
                                        IOPCTL_PIO_INV_DI |
                                        /* Selects transmitter current drive 100ohm */
                                        IOPCTL_PIO_DRIVE_100OHM);
    /* PORT1 PIN0 (coords: N5) is configured as LP_FLEXCOMM0_P1 */
    IOPCTL_PinMuxSet(1U, 0U, port1_pin0_config);

    const uint32_t port7_pin11_config = (/* Pin is configured as PIO7_11 */
                                         IOPCTL_PIO_FUNC0 |
                                         /* Disable pull-up / pull-down function */
                                         IOPCTL_PIO_PUPD_DI |
                                         /* Enable pull-down function */
                                         IOPCTL_PIO_PULLDOWN_EN |
                                         /* Disable input buffer function */
                                         IOPCTL_PIO_INBUF_DI |
                                         /* Pseudo Output Drain is disabled */
                                         IOPCTL_PIO_PSEDRAIN_DI |
                                         /* Input function is not inverted */
                                         IOPCTL_PIO_INV_DI |
                                         /* Selects transmitter current drive 100ohm */
                                         IOPCTL_PIO_DRIVE_100OHM);
    /* PORT7 PIN11 (coords: C5) is configured as PIO7_11 */
    IOPCTL_PinMuxSet(7U, 11U, port7_pin11_config);

    const uint32_t port7_pin17_config = (/* Pin is configured as SDHC1_CLK */
                                         IOPCTL_PIO_FUNC1 |
                                         /* Enable pull-up / pull-down function */
                                         IOPCTL_PIO_PUPD_EN |
                                         /* Enable pull-up function */
                                         IOPCTL_PIO_PULLUP_EN |
                                         /* Enables input buffer function */
                                         IOPCTL_PIO_INBUF_EN |
                                         /* Pseudo Output Drain is disabled */
                                         IOPCTL_PIO_PSEDRAIN_DI |
                                         /* Input function is not inverted */
                                         IOPCTL_PIO_INV_DI |
                                         /* Selects transmitter current drive 33ohm */
                                         IOPCTL_PIO_DRIVE_33OHM);
    /* PORT7 PIN17 (coords: L17) is configured as SDHC1_CLK */
    IOPCTL_PinMuxSet(7U, 17U, port7_pin17_config);

    const uint32_t port7_pin18_config = (/* Pin is configured as SDHC1_CMD */
                                         IOPCTL_PIO_FUNC1 |
                                         /* Enable pull-up / pull-down function */
                                         IOPCTL_PIO_PUPD_EN |
                                         /* Enable pull-up function */
                                         IOPCTL_PIO_PULLUP_EN |
                                         /* Enables input buffer function */
                                         IOPCTL_PIO_INBUF_EN |
                                         /* Pseudo Output Drain is disabled */
                                         IOPCTL_PIO_PSEDRAIN_DI |
                                         /* Input function is not inverted */
                                         IOPCTL_PIO_INV_DI |
                                         /* Selects transmitter current drive 33ohm */
                                         IOPCTL_PIO_DRIVE_33OHM);
    /* PORT7 PIN18 (coords: L16) is configured as SDHC1_CMD */
    IOPCTL_PinMuxSet(7U, 18U, port7_pin18_config);

    const uint32_t port7_pin19_config = (/* Pin is configured as SDHC1_DATA0 */
                                         IOPCTL_PIO_FUNC1 |
                                         /* Enable pull-up / pull-down function */
                                         IOPCTL_PIO_PUPD_EN |
                                         /* Enable pull-up function */
                                         IOPCTL_PIO_PULLUP_EN |
                                         /* Enables input buffer function */
                                         IOPCTL_PIO_INBUF_EN |
                                         /* Pseudo Output Drain is disabled */
                                         IOPCTL_PIO_PSEDRAIN_DI |
                                         /* Input function is not inverted */
                                         IOPCTL_PIO_INV_DI |
                                         /* Selects transmitter current drive 33ohm */
                                         IOPCTL_PIO_DRIVE_33OHM);
    /* PORT7 PIN19 (coords: M17) is configured as SDHC1_DATA0 */
    IOPCTL_PinMuxSet(7U, 19U, port7_pin19_config);

    const uint32_t port7_pin20_config = (/* Pin is configured as SDHC1_DATA1 */
                                         IOPCTL_PIO_FUNC1 |
                                         /* Enable pull-up / pull-down function */
                                         IOPCTL_PIO_PUPD_EN |
                                         /* Enable pull-up function */
                                         IOPCTL_PIO_PULLUP_EN |
                                         /* Enables input buffer function */
                                         IOPCTL_PIO_INBUF_EN |
                                         /* Pseudo Output Drain is disabled */
                                         IOPCTL_PIO_PSEDRAIN_DI |
                                         /* Input function is not inverted */
                                         IOPCTL_PIO_INV_DI |
                                         /* Selects transmitter current drive 33ohm */
                                         IOPCTL_PIO_DRIVE_33OHM);
    /* PORT7 PIN20 (coords: M18) is configured as SDHC1_DATA1 */
    IOPCTL_PinMuxSet(7U, 20U, port7_pin20_config);

    const uint32_t port7_pin21_config = (/* Pin is configured as SDHC1_DATA2 */
                                         IOPCTL_PIO_FUNC1 |
                                         /* Enable pull-up / pull-down function */
                                         IOPCTL_PIO_PUPD_EN |
                                         /* Enable pull-up function */
                                         IOPCTL_PIO_PULLUP_EN |
                                         /* Enables input buffer function */
                                         IOPCTL_PIO_INBUF_EN |
                                         /* Pseudo Output Drain is disabled */
                                         IOPCTL_PIO_PSEDRAIN_DI |
                                         /* Input function is not inverted */
                                         IOPCTL_PIO_INV_DI |
                                         /* Selects transmitter current drive 33ohm */
                                         IOPCTL_PIO_DRIVE_33OHM);
    /* PORT7 PIN21 (coords: K18) is configured as SDHC1_DATA2 */
    IOPCTL_PinMuxSet(7U, 21U, port7_pin21_config);

    const uint32_t port7_pin22_config = (/* Pin is configured as SDHC1_DATA3 */
                                         IOPCTL_PIO_FUNC1 |
                                         /* Enable pull-up / pull-down function */
                                         IOPCTL_PIO_PUPD_EN |
                                         /* Enable pull-up function */
                                         IOPCTL_PIO_PULLUP_EN |
                                         /* Enables input buffer function */
                                         IOPCTL_PIO_INBUF_EN |
                                         /* Pseudo Output Drain is disabled */
                                         IOPCTL_PIO_PSEDRAIN_DI |
                                         /* Input function is not inverted */
                                         IOPCTL_PIO_INV_DI |
                                         /* Selects transmitter current drive 33ohm */
                                         IOPCTL_PIO_DRIVE_33OHM);
    /* PORT7 PIN22 (coords: K17) is configured as SDHC1_DATA3 */
    IOPCTL_PinMuxSet(7U, 22U, port7_pin22_config);

    const uint32_t port7_pin24_config = (/* Pin is configured as SDHC1_CARD_DET_N */
                                         IOPCTL_PIO_FUNC1 |
                                         /* Enable pull-up / pull-down function */
                                         IOPCTL_PIO_PUPD_EN |
                                         /* Enable pull-up function */
                                         IOPCTL_PIO_PULLUP_EN |
                                         /* Enables input buffer function */
                                         IOPCTL_PIO_INBUF_EN |
                                         /* Pseudo Output Drain is disabled */
                                         IOPCTL_PIO_PSEDRAIN_DI |
                                         /* Input function is not inverted */
                                         IOPCTL_PIO_INV_DI |
                                         /* Selects transmitter current drive 33ohm */
                                         IOPCTL_PIO_DRIVE_33OHM);
    /* PORT7 PIN24 (coords: G12) is configured as SDHC1_CARD_DET_N */
    IOPCTL_PinMuxSet(7U, 24U, port7_pin24_config);
}

/* clang-format off */
/*
 * TEXT BELOW IS USED AS SETTING FOR TOOLS *************************************
BOARD_InitMipiPanelPinsEvk:
- options: {callFromInitBoot: 'false', coreID: cm33_core0, enableClock: 'true'}
- pin_list:
  - {pin_num: K6, peripheral: GPIO3, signal: 'GPIO, 4', pin_signal: PIO3_4}
  - {pin_num: K7, peripheral: GPIO3, signal: 'GPIO, 5', pin_signal: PIO3_5, input_buffer: enable}
  - {pin_num: T2, peripheral: GPIO1, signal: 'GPIO, 10', pin_signal: PIO1_10}
  - {pin_num: P3, peripheral: GPIO1, signal: 'GPIO, 14', pin_signal: PIO1_14}
 * BE CAREFUL MODIFYING THIS COMMENT - IT IS YAML SETTINGS FOR TOOLS ***********
 */
/* clang-format on */

/* FUNCTION ************************************************************************************************************
 *
 * Function Name : BOARD_InitMipiPanelPinsEvk
 * Description   : Configures pin routing and optionally pin electrical features.
 *
 * END ****************************************************************************************************************/
/* Function assigned for the Cortex-M33 (Core #0) */
void BOARD_InitMipiPanelPinsEvk(void)
{

    const uint32_t port1_pin10_config = (/* Pin is configured as GPIO1_IO10 */
                                         IOPCTL_PIO_FUNC0 |
                                         /* Disable pull-up / pull-down function */
                                         IOPCTL_PIO_PUPD_DI |
                                         /* Enable pull-down function */
                                         IOPCTL_PIO_PULLDOWN_EN |
                                         /* Disable input buffer function */
                                         IOPCTL_PIO_INBUF_DI |
                                         /* Normal mode */
                                         IOPCTL_PIO_SLEW_RATE_NORMAL |
                                         /* Normal drive */
                                         IOPCTL_PIO_FULLDRIVE_DI |
                                         /* Analog mux is disabled */
                                         IOPCTL_PIO_ANAMUX_DI |
                                         /* Pseudo Output Drain is disabled */
                                         IOPCTL_PIO_PSEDRAIN_DI |
                                         /* Input function is not inverted */
                                         IOPCTL_PIO_INV_DI);
    /* PORT1 PIN10 (coords: T2) is configured as GPIO1_IO10 */
    IOPCTL_PinMuxSet(1U, 10U, port1_pin10_config);

    const uint32_t port1_pin14_config = (/* Pin is configured as GPIO1_IO14 */
                                         IOPCTL_PIO_FUNC0 |
                                         /* Disable pull-up / pull-down function */
                                         IOPCTL_PIO_PUPD_DI |
                                         /* Enable pull-down function */
                                         IOPCTL_PIO_PULLDOWN_EN |
                                         /* Disable input buffer function */
                                         IOPCTL_PIO_INBUF_DI |
                                         /* Normal mode */
                                         IOPCTL_PIO_SLEW_RATE_NORMAL |
                                         /* Normal drive */
                                         IOPCTL_PIO_FULLDRIVE_DI |
                                         /* Analog mux is disabled */
                                         IOPCTL_PIO_ANAMUX_DI |
                                         /* Pseudo Output Drain is disabled */
                                         IOPCTL_PIO_PSEDRAIN_DI |
                                         /* Input function is not inverted */
                                         IOPCTL_PIO_INV_DI);
    /* PORT1 PIN14 (coords: P3) is configured as GPIO1_IO14 */
    IOPCTL_PinMuxSet(1U, 14U, port1_pin14_config);

    const uint32_t port3_pin4_config = (/* Pin is configured as GPIO3_IO4 */
                                        IOPCTL_PIO_FUNC0 |
                                        /* Disable pull-up / pull-down function */
                                        IOPCTL_PIO_PUPD_DI |
                                        /* Enable pull-down function */
                                        IOPCTL_PIO_PULLDOWN_EN |
                                        /* Disable input buffer function */
                                        IOPCTL_PIO_INBUF_DI |
                                        /* Normal mode */
                                        IOPCTL_PIO_SLEW_RATE_NORMAL |
                                        /* Normal drive */
                                        IOPCTL_PIO_FULLDRIVE_DI |
                                        /* Analog mux is disabled */
                                        IOPCTL_PIO_ANAMUX_DI |
                                        /* Pseudo Output Drain is disabled */
                                        IOPCTL_PIO_PSEDRAIN_DI |
                                        /* Input function is not inverted */
                                        IOPCTL_PIO_INV_DI);
    /* PORT3 PIN4 (coords: K6) is configured as GPIO3_IO4 */
    IOPCTL_PinMuxSet(3U, 4U, port3_pin4_config);

    const uint32_t port3_pin5_config = (/* Pin is configured as GPIO3_IO5 */
                                        IOPCTL_PIO_FUNC0 |
                                        /* Disable pull-up / pull-down function */
                                        IOPCTL_PIO_PUPD_DI |
                                        /* Enable pull-down function */
                                        IOPCTL_PIO_PULLDOWN_EN |
                                        /* Enable input buffer function */
                                        IOPCTL_PIO_INBUF_EN |
                                        /* Normal mode */
                                        IOPCTL_PIO_SLEW_RATE_NORMAL |
                                        /* Normal drive */
                                        IOPCTL_PIO_FULLDRIVE_DI |
                                        /* Analog mux is disabled */
                                        IOPCTL_PIO_ANAMUX_DI |
                                        /* Pseudo Output Drain is disabled */
                                        IOPCTL_PIO_PSEDRAIN_DI |
                                        /* Input function is not inverted */
                                        IOPCTL_PIO_INV_DI);
    /* PORT3 PIN5 (coords: K7) is configured as GPIO3_IO5 */
    IOPCTL_PinMuxSet(3U, 5U, port3_pin5_config);
}

/* clang-format off */
/*
 * TEXT BELOW IS USED AS SETTING FOR TOOLS *************************************
BOARD_InitUARTPins:
- options: {callFromInitBoot: 'true', coreID: cm33_core0, enableClock: 'true'}
- pin_list:
  - {pin_num: N4, peripheral: LP_FLEXCOMM0, signal: P0, pin_signal: PIO0_31}
  - {pin_num: N5, peripheral: LP_FLEXCOMM0, signal: P1, pin_signal: PIO1_0}
 * BE CAREFUL MODIFYING THIS COMMENT - IT IS YAML SETTINGS FOR TOOLS ***********
 */
/* clang-format on */

/* FUNCTION ************************************************************************************************************
 *
 * Function Name : BOARD_InitUARTPins
 * Description   : Configures pin routing and optionally pin electrical features.
 *
 * END ****************************************************************************************************************/
/* Function assigned for the Cortex-M33 (Core #0) */
void BOARD_InitUARTPins(void)
{

    const uint32_t port0_pin31_config = (/* Pin is configured as LP_FLEXCOMM0_P0 */
                                         IOPCTL_PIO_FUNC1 |
                                         /* Disable pull-up / pull-down function */
                                         IOPCTL_PIO_PUPD_DI |
                                         /* Enable pull-down function */
                                         IOPCTL_PIO_PULLDOWN_EN |
                                         /* Disable input buffer function */
                                         IOPCTL_PIO_INBUF_DI |
                                         /* Normal mode */
                                         IOPCTL_PIO_SLEW_RATE_NORMAL |
                                         /* Normal drive */
                                         IOPCTL_PIO_FULLDRIVE_DI |
                                         /* Analog mux is disabled */
                                         IOPCTL_PIO_ANAMUX_DI |
                                         /* Pseudo Output Drain is disabled */
                                         IOPCTL_PIO_PSEDRAIN_DI |
                                         /* Input function is not inverted */
                                         IOPCTL_PIO_INV_DI);
    /* PORT0 PIN31 (coords: N4) is configured as LP_FLEXCOMM0_P0 */
    IOPCTL_PinMuxSet(0U, 31U, port0_pin31_config);

    const uint32_t port1_pin0_config = (/* Pin is configured as LP_FLEXCOMM0_P1 */
                                        IOPCTL_PIO_FUNC1 |
                                        /* Disable pull-up / pull-down function */
                                        IOPCTL_PIO_PUPD_DI |
                                        /* Enable pull-down function */
                                        IOPCTL_PIO_PULLDOWN_EN |
                                        /* Disable input buffer function */
                                        IOPCTL_PIO_INBUF_DI |
                                        /* Normal mode */
                                        IOPCTL_PIO_SLEW_RATE_NORMAL |
                                        /* Normal drive */
                                        IOPCTL_PIO_FULLDRIVE_DI |
                                        /* Analog mux is disabled */
                                        IOPCTL_PIO_ANAMUX_DI |
                                        /* Pseudo Output Drain is disabled */
                                        IOPCTL_PIO_PSEDRAIN_DI |
                                        /* Input function is not inverted */
                                        IOPCTL_PIO_INV_DI);
    /* PORT1 PIN0 (coords: N5) is configured as LP_FLEXCOMM0_P1 */
    IOPCTL_PinMuxSet(1U, 0U, port1_pin0_config);
}

/* clang-format off */
/*
 * TEXT BELOW IS USED AS SETTING FOR TOOLS *************************************
BOARD_InitFlexIOPanelPins:
- options: {callFromInitBoot: 'true', coreID: cm33_core0, enableClock: 'true'}
- pin_list:
  - {pin_num: H6, peripheral: FLEXIO, signal: 'D, 6', pin_signal: PIO2_6, input_buffer: enable}
  - {pin_num: G6, peripheral: FLEXIO, signal: 'D, 7', pin_signal: PIO2_7, input_buffer: enable}
  - {pin_num: G4, peripheral: FLEXIO, signal: 'D, 8', pin_signal: PIO2_8, input_buffer: enable}
  - {pin_num: G5, peripheral: FLEXIO, signal: 'D, 9', pin_signal: PIO2_9, input_buffer: enable}
  - {pin_num: F5, peripheral: FLEXIO, signal: 'D, 10', pin_signal: PIO2_10, input_buffer: enable}
  - {pin_num: F3, peripheral: FLEXIO, signal: 'D, 11', pin_signal: PIO2_11, input_buffer: enable}
  - {pin_num: E3, peripheral: FLEXIO, signal: 'D, 12', pin_signal: PIO2_12, input_buffer: enable}
  - {pin_num: E4, peripheral: FLEXIO, signal: 'D, 13', pin_signal: PIO2_13, input_buffer: enable}
  - {pin_num: H2, peripheral: GPIO2, signal: 'GPIO, 0', pin_signal: PIO2_0, direction: OUTPUT, gpio_direction: out}
  - {pin_num: G2, peripheral: GPIO2, signal: 'GPIO, 1', pin_signal: PIO2_1, direction: OUTPUT, gpio_direction: out}
  - {pin_num: D3, peripheral: GPIO2, signal: 'GPIO, 15', pin_signal: PIO2_15, direction: OUTPUT, gpio_direction: out}
  - {pin_num: G1, peripheral: FLEXIO, signal: 'D, 3', pin_signal: PIO2_3, direction: OUTPUT}
  - {pin_num: G3, peripheral: FLEXIO, signal: 'D, 4', pin_signal: PIO2_4, direction: OUTPUT, slew_rate: slow, input_buffer: enable, pull_select: up, pull_enable: enable}
 * BE CAREFUL MODIFYING THIS COMMENT - IT IS YAML SETTINGS FOR TOOLS ***********
 */
/* clang-format on */

/* clang-format off */
/*
 * TEXT BELOW IS USED AS SETTING FOR TOOLS *************************************
BOARD_InitFlexIOPanelPins:
- options: {callFromInitBoot: 'true', coreID: cm33_core0, enableClock: 'true'}
- pin_list:
  - {pin_num: H6, peripheral: FLEXIO, signal: 'D, 6', pin_signal: PIO2_6, slew_rate: slow, input_buffer: enable, pull_enable: enable}
  - {pin_num: G6, peripheral: FLEXIO, signal: 'D, 7', pin_signal: PIO2_7, slew_rate: slow, input_buffer: enable, pull_enable: enable}
  - {pin_num: G4, peripheral: FLEXIO, signal: 'D, 8', pin_signal: PIO2_8, slew_rate: slow, input_buffer: enable, pull_enable: enable}
  - {pin_num: G5, peripheral: FLEXIO, signal: 'D, 9', pin_signal: PIO2_9, slew_rate: slow, input_buffer: enable, pull_enable: enable}
  - {pin_num: F5, peripheral: FLEXIO, signal: 'D, 10', pin_signal: PIO2_10, slew_rate: slow, input_buffer: enable, pull_enable: enable}
  - {pin_num: F3, peripheral: FLEXIO, signal: 'D, 11', pin_signal: PIO2_11, slew_rate: slow, input_buffer: enable, pull_enable: enable}
  - {pin_num: E3, peripheral: FLEXIO, signal: 'D, 12', pin_signal: PIO2_12, slew_rate: slow, input_buffer: enable, pull_enable: enable}
  - {pin_num: E4, peripheral: FLEXIO, signal: 'D, 13', pin_signal: PIO2_13, slew_rate: slow, input_buffer: enable, pull_enable: enable}
  - {pin_num: H2, peripheral: GPIO2, signal: 'GPIO, 0', pin_signal: PIO2_0, direction: OUTPUT, gpio_direction: out}
  - {pin_num: G2, peripheral: GPIO2, signal: 'GPIO, 1', pin_signal: PIO2_1, direction: OUTPUT, gpio_direction: out}
  - {pin_num: D3, peripheral: GPIO2, signal: 'GPIO, 15', pin_signal: PIO2_15, direction: OUTPUT, gpio_direction: out}
  - {pin_num: G1, peripheral: FLEXIO, signal: 'D, 3', pin_signal: PIO2_3, direction: OUTPUT}
  - {pin_num: G3, peripheral: FLEXIO, signal: 'D, 4', pin_signal: PIO2_4, direction: OUTPUT, slew_rate: slow, input_buffer: enable, pull_select: up, pull_enable: enable}
 * BE CAREFUL MODIFYING THIS COMMENT - IT IS YAML SETTINGS FOR TOOLS ***********
 */
/* clang-format on */

/* FUNCTION ************************************************************************************************************
 *
 * Function Name : BOARD_InitFlexIOPanelPins
 * Description   : Configures pin routing and optionally pin electrical features.
 *
 * END ****************************************************************************************************************/
/* Function assigned for the Cortex-M33 (Core #0) */
void BOARD_InitFlexIOPanelPins(void)
{

    GPIO2->PDDR = ((GPIO2->PDDR &
                    /* Mask bits to zero which are setting */
                    (~(GPIO_PDDR_PDD0_MASK | GPIO_PDDR_PDD1_MASK | GPIO_PDDR_PDD15_MASK)))

                   /* Port Data Direction: Pin is configured as general-purpose output for the GPIO function. */
                   | GPIO_PDDR_PDD0(PDDR_PDD0_pdd1)

                   /* Port Data Direction: Pin is configured as general-purpose output for the GPIO function. */
                   | GPIO_PDDR_PDD1(PDDR_PDD1_pdd1)

                   /* Port Data Direction: Pin is configured as general-purpose output for the GPIO function. */
                   | GPIO_PDDR_PDD15(PDDR_PDD15_pdd1));

    const uint32_t port2_pin0_config = (/* Pin is configured as GPIO2_IO0 */
                                        IOPCTL_PIO_FUNC0 |
                                        /* Disable pull-up / pull-down function */
                                        IOPCTL_PIO_PUPD_DI |
                                        /* Enable pull-down function */
                                        IOPCTL_PIO_PULLDOWN_EN |
                                        /* Disable input buffer function */
                                        IOPCTL_PIO_INBUF_DI |
                                        /* Normal mode */
                                        IOPCTL_PIO_SLEW_RATE_NORMAL |
                                        /* Normal drive */
                                        IOPCTL_PIO_FULLDRIVE_DI |
                                        /* Analog mux is disabled */
                                        IOPCTL_PIO_ANAMUX_DI |
                                        /* Pseudo Output Drain is disabled */
                                        IOPCTL_PIO_PSEDRAIN_DI |
                                        /* Input function is not inverted */
                                        IOPCTL_PIO_INV_DI);
    /* PORT2 PIN0 (coords: H2) is configured as GPIO2_IO0 */
    IOPCTL_PinMuxSet(2U, 0U, port2_pin0_config);

    const uint32_t port2_pin1_config = (/* Pin is configured as GPIO2_IO1 */
                                        IOPCTL_PIO_FUNC0 |
                                        /* Disable pull-up / pull-down function */
                                        IOPCTL_PIO_PUPD_DI |
                                        /* Enable pull-down function */
                                        IOPCTL_PIO_PULLDOWN_EN |
                                        /* Disable input buffer function */
                                        IOPCTL_PIO_INBUF_DI |
                                        /* Normal mode */
                                        IOPCTL_PIO_SLEW_RATE_NORMAL |
                                        /* Normal drive */
                                        IOPCTL_PIO_FULLDRIVE_DI |
                                        /* Analog mux is disabled */
                                        IOPCTL_PIO_ANAMUX_DI |
                                        /* Pseudo Output Drain is disabled */
                                        IOPCTL_PIO_PSEDRAIN_DI |
                                        /* Input function is not inverted */
                                        IOPCTL_PIO_INV_DI);
    /* PORT2 PIN1 (coords: G2) is configured as GPIO2_IO1 */
    IOPCTL_PinMuxSet(2U, 1U, port2_pin1_config);

    const uint32_t port2_pin10_config = (/* Pin is configured as FLEXIO_D10 */
                                         IOPCTL_PIO_FUNC5 |
                                         /* Enable pull-up / pull-down function */
                                         IOPCTL_PIO_PUPD_EN |
                                         /* Enable pull-down function */
                                         IOPCTL_PIO_PULLDOWN_EN |
                                         /* Enables input buffer function */
                                         IOPCTL_PIO_INBUF_EN |
                                         /* Slow mode */
                                         IOPCTL_PIO_SLEW_RATE_SLOW |
                                         /* Normal drive */
                                         IOPCTL_PIO_FULLDRIVE_DI |
                                         /* Analog mux is disabled */
                                         IOPCTL_PIO_ANAMUX_DI |
                                         /* Pseudo Output Drain is disabled */
                                         IOPCTL_PIO_PSEDRAIN_DI |
                                         /* Input function is not inverted */
                                         IOPCTL_PIO_INV_DI);
    /* PORT2 PIN10 (coords: F5) is configured as FLEXIO_D10 */
    IOPCTL_PinMuxSet(2U, 10U, port2_pin10_config);

    const uint32_t port2_pin11_config = (/* Pin is configured as FLEXIO_D11 */
                                         IOPCTL_PIO_FUNC5 |
                                         /* Enable pull-up / pull-down function */
                                         IOPCTL_PIO_PUPD_EN |
                                         /* Enable pull-down function */
                                         IOPCTL_PIO_PULLDOWN_EN |
                                         /* Enables input buffer function */
                                         IOPCTL_PIO_INBUF_EN |
                                         /* Slow mode */
                                         IOPCTL_PIO_SLEW_RATE_SLOW |
                                         /* Normal drive */
                                         IOPCTL_PIO_FULLDRIVE_DI |
                                         /* Analog mux is disabled */
                                         IOPCTL_PIO_ANAMUX_DI |
                                         /* Pseudo Output Drain is disabled */
                                         IOPCTL_PIO_PSEDRAIN_DI |
                                         /* Input function is not inverted */
                                         IOPCTL_PIO_INV_DI);
    /* PORT2 PIN11 (coords: F3) is configured as FLEXIO_D11 */
    IOPCTL_PinMuxSet(2U, 11U, port2_pin11_config);

    const uint32_t port2_pin12_config = (/* Pin is configured as FLEXIO_D12 */
                                         IOPCTL_PIO_FUNC5 |
                                         /* Enable pull-up / pull-down function */
                                         IOPCTL_PIO_PUPD_EN |
                                         /* Enable pull-down function */
                                         IOPCTL_PIO_PULLDOWN_EN |
                                         /* Enables input buffer function */
                                         IOPCTL_PIO_INBUF_EN |
                                         /* Slow mode */
                                         IOPCTL_PIO_SLEW_RATE_SLOW |
                                         /* Normal drive */
                                         IOPCTL_PIO_FULLDRIVE_DI |
                                         /* Analog mux is disabled */
                                         IOPCTL_PIO_ANAMUX_DI |
                                         /* Pseudo Output Drain is disabled */
                                         IOPCTL_PIO_PSEDRAIN_DI |
                                         /* Input function is not inverted */
                                         IOPCTL_PIO_INV_DI);
    /* PORT2 PIN12 (coords: E3) is configured as FLEXIO_D12 */
    IOPCTL_PinMuxSet(2U, 12U, port2_pin12_config);

    const uint32_t port2_pin13_config = (/* Pin is configured as FLEXIO_D13 */
                                         IOPCTL_PIO_FUNC5 |
                                         /* Enable pull-up / pull-down function */
                                         IOPCTL_PIO_PUPD_EN |
                                         /* Enable pull-down function */
                                         IOPCTL_PIO_PULLDOWN_EN |
                                         /* Enables input buffer function */
                                         IOPCTL_PIO_INBUF_EN |
                                         /* Slow mode */
                                         IOPCTL_PIO_SLEW_RATE_SLOW |
                                         /* Normal drive */
                                         IOPCTL_PIO_FULLDRIVE_DI |
                                         /* Analog mux is disabled */
                                         IOPCTL_PIO_ANAMUX_DI |
                                         /* Pseudo Output Drain is disabled */
                                         IOPCTL_PIO_PSEDRAIN_DI |
                                         /* Input function is not inverted */
                                         IOPCTL_PIO_INV_DI);
    /* PORT2 PIN13 (coords: E4) is configured as FLEXIO_D13 */
    IOPCTL_PinMuxSet(2U, 13U, port2_pin13_config);

    const uint32_t port2_pin15_config = (/* Pin is configured as GPIO2_IO15 */
                                         IOPCTL_PIO_FUNC0 |
                                         /* Disable pull-up / pull-down function */
                                         IOPCTL_PIO_PUPD_DI |
                                         /* Enable pull-down function */
                                         IOPCTL_PIO_PULLDOWN_EN |
                                         /* Disable input buffer function */
                                         IOPCTL_PIO_INBUF_DI |
                                         /* Normal mode */
                                         IOPCTL_PIO_SLEW_RATE_NORMAL |
                                         /* Normal drive */
                                         IOPCTL_PIO_FULLDRIVE_DI |
                                         /* Analog mux is disabled */
                                         IOPCTL_PIO_ANAMUX_DI |
                                         /* Pseudo Output Drain is disabled */
                                         IOPCTL_PIO_PSEDRAIN_DI |
                                         /* Input function is not inverted */
                                         IOPCTL_PIO_INV_DI);
    /* PORT2 PIN15 (coords: D3) is configured as GPIO2_IO15 */
    IOPCTL_PinMuxSet(2U, 15U, port2_pin15_config);

    const uint32_t port2_pin3_config = (/* Pin is configured as FLEXIO_D3 */
                                        IOPCTL_PIO_FUNC5 |
                                        /* Disable pull-up / pull-down function */
                                        IOPCTL_PIO_PUPD_DI |
                                        /* Enable pull-down function */
                                        IOPCTL_PIO_PULLDOWN_EN |
                                        /* Disable input buffer function */
                                        IOPCTL_PIO_INBUF_DI |
                                        /* Normal mode */
                                        IOPCTL_PIO_SLEW_RATE_NORMAL |
                                        /* Normal drive */
                                        IOPCTL_PIO_FULLDRIVE_DI |
                                        /* Analog mux is disabled */
                                        IOPCTL_PIO_ANAMUX_DI |
                                        /* Pseudo Output Drain is disabled */
                                        IOPCTL_PIO_PSEDRAIN_DI |
                                        /* Input function is not inverted */
                                        IOPCTL_PIO_INV_DI);
    /* PORT2 PIN3 (coords: G1) is configured as FLEXIO_D3 */
    IOPCTL_PinMuxSet(2U, 3U, port2_pin3_config);

    const uint32_t port2_pin4_config = (/* Pin is configured as FLEXIO_D4 */
                                        IOPCTL_PIO_FUNC5 |
                                        /* Enable pull-up / pull-down function */
                                        IOPCTL_PIO_PUPD_EN |
                                        /* Enable pull-up function */
                                        IOPCTL_PIO_PULLUP_EN |
                                        /* Enables input buffer function */
                                        IOPCTL_PIO_INBUF_EN |
                                        /* Slow mode */
                                        IOPCTL_PIO_SLEW_RATE_SLOW |
                                        /* Normal drive */
                                        IOPCTL_PIO_FULLDRIVE_DI |
                                        /* Analog mux is disabled */
                                        IOPCTL_PIO_ANAMUX_DI |
                                        /* Pseudo Output Drain is disabled */
                                        IOPCTL_PIO_PSEDRAIN_DI |
                                        /* Input function is not inverted */
                                        IOPCTL_PIO_INV_DI);
    /* PORT2 PIN4 (coords: G3) is configured as FLEXIO_D4 */
    IOPCTL_PinMuxSet(2U, 4U, port2_pin4_config);

    const uint32_t port2_pin6_config = (/* Pin is configured as FLEXIO_D6 */
                                        IOPCTL_PIO_FUNC5 |
                                        /* Enable pull-up / pull-down function */
                                        IOPCTL_PIO_PUPD_EN |
                                        /* Enable pull-down function */
                                        IOPCTL_PIO_PULLDOWN_EN |
                                        /* Enables input buffer function */
                                        IOPCTL_PIO_INBUF_EN |
                                        /* Slow mode */
                                        IOPCTL_PIO_SLEW_RATE_SLOW |
                                        /* Normal drive */
                                        IOPCTL_PIO_FULLDRIVE_DI |
                                        /* Analog mux is disabled */
                                        IOPCTL_PIO_ANAMUX_DI |
                                        /* Pseudo Output Drain is disabled */
                                        IOPCTL_PIO_PSEDRAIN_DI |
                                        /* Input function is not inverted */
                                        IOPCTL_PIO_INV_DI);
    /* PORT2 PIN6 (coords: H6) is configured as FLEXIO_D6 */
    IOPCTL_PinMuxSet(2U, 6U, port2_pin6_config);

    const uint32_t port2_pin7_config = (/* Pin is configured as FLEXIO_D7 */
                                        IOPCTL_PIO_FUNC5 |
                                        /* Enable pull-up / pull-down function */
                                        IOPCTL_PIO_PUPD_EN |
                                        /* Enable pull-down function */
                                        IOPCTL_PIO_PULLDOWN_EN |
                                        /* Enables input buffer function */
                                        IOPCTL_PIO_INBUF_EN |
                                        /* Slow mode */
                                        IOPCTL_PIO_SLEW_RATE_SLOW |
                                        /* Normal drive */
                                        IOPCTL_PIO_FULLDRIVE_DI |
                                        /* Analog mux is disabled */
                                        IOPCTL_PIO_ANAMUX_DI |
                                        /* Pseudo Output Drain is disabled */
                                        IOPCTL_PIO_PSEDRAIN_DI |
                                        /* Input function is not inverted */
                                        IOPCTL_PIO_INV_DI);
    /* PORT2 PIN7 (coords: G6) is configured as FLEXIO_D7 */
    IOPCTL_PinMuxSet(2U, 7U, port2_pin7_config);

    const uint32_t port2_pin8_config = (/* Pin is configured as FLEXIO_D8 */
                                        IOPCTL_PIO_FUNC5 |
                                        /* Enable pull-up / pull-down function */
                                        IOPCTL_PIO_PUPD_EN |
                                        /* Enable pull-down function */
                                        IOPCTL_PIO_PULLDOWN_EN |
                                        /* Enables input buffer function */
                                        IOPCTL_PIO_INBUF_EN |
                                        /* Slow mode */
                                        IOPCTL_PIO_SLEW_RATE_SLOW |
                                        /* Normal drive */
                                        IOPCTL_PIO_FULLDRIVE_DI |
                                        /* Analog mux is disabled */
                                        IOPCTL_PIO_ANAMUX_DI |
                                        /* Pseudo Output Drain is disabled */
                                        IOPCTL_PIO_PSEDRAIN_DI |
                                        /* Input function is not inverted */
                                        IOPCTL_PIO_INV_DI);
    /* PORT2 PIN8 (coords: G4) is configured as FLEXIO_D8 */
    IOPCTL_PinMuxSet(2U, 8U, port2_pin8_config);

    const uint32_t port2_pin9_config = (/* Pin is configured as FLEXIO_D9 */
                                        IOPCTL_PIO_FUNC5 |
                                        /* Enable pull-up / pull-down function */
                                        IOPCTL_PIO_PUPD_EN |
                                        /* Enable pull-down function */
                                        IOPCTL_PIO_PULLDOWN_EN |
                                        /* Enables input buffer function */
                                        IOPCTL_PIO_INBUF_EN |
                                        /* Slow mode */
                                        IOPCTL_PIO_SLEW_RATE_SLOW |
                                        /* Normal drive */
                                        IOPCTL_PIO_FULLDRIVE_DI |
                                        /* Analog mux is disabled */
                                        IOPCTL_PIO_ANAMUX_DI |
                                        /* Pseudo Output Drain is disabled */
                                        IOPCTL_PIO_PSEDRAIN_DI |
                                        /* Input function is not inverted */
                                        IOPCTL_PIO_INV_DI);
    /* PORT2 PIN9 (coords: G5) is configured as FLEXIO_D9 */
    IOPCTL_PinMuxSet(2U, 9U, port2_pin9_config);
}

/* clang-format off */
/*
 * TEXT BELOW IS USED AS SETTING FOR TOOLS *************************************
BOARD_InitLcdDBIPanelPins:
- options: {callFromInitBoot: 'false', coreID: cm33_core0, enableClock: 'true'}
- pin_list:
  - {pin_num: D3, peripheral: GPIO2, signal: 'GPIO, 15', pin_signal: PIO2_15, direction: OUTPUT, gpio_direction: out}
  - {pin_num: H6, peripheral: LCDIF, signal: 'DBI_DATA, 0', pin_signal: PIO2_6, slew_rate: slow, input_buffer: enable, pull_enable: enable}
  - {pin_num: G6, peripheral: LCDIF, signal: 'DBI_DATA, 1', pin_signal: PIO2_7, slew_rate: slow, input_buffer: enable, pull_enable: enable}
  - {pin_num: G4, peripheral: LCDIF, signal: 'DBI_DATA, 2', pin_signal: PIO2_8, slew_rate: slow, input_buffer: enable, pull_enable: enable}
  - {pin_num: G5, peripheral: LCDIF, signal: 'DBI_DATA, 3', pin_signal: PIO2_9, slew_rate: slow, input_buffer: enable, pull_enable: enable}
  - {pin_num: F5, peripheral: LCDIF, signal: 'DBI_DATA, 4', pin_signal: PIO2_10, slew_rate: slow, input_buffer: enable, pull_enable: enable}
  - {pin_num: F3, peripheral: LCDIF, signal: 'DBI_DATA, 5', pin_signal: PIO2_11, slew_rate: slow, input_buffer: enable, pull_enable: enable}
  - {pin_num: E3, peripheral: LCDIF, signal: 'DBI_DATA, 6', pin_signal: PIO2_12, slew_rate: slow, input_buffer: enable, pull_enable: enable}
  - {pin_num: E4, peripheral: LCDIF, signal: 'DBI_DATA, 7', pin_signal: PIO2_13, slew_rate: slow, input_buffer: enable, pull_enable: enable}
  - {pin_num: G1, peripheral: LCDIF, signal: DBI_RWDX, pin_signal: PIO2_3, direction: OUTPUT, slew_rate: slow, input_buffer: disable, pull_select: up, pull_enable: disable}
  - {pin_num: G3, peripheral: LCDIF, signal: DBI_WRX, pin_signal: PIO2_4, direction: OUTPUT, slew_rate: standard, input_buffer: disable, pull_select: up,
    pull_enable: disable}
  - {pin_num: H2, peripheral: LCDIF, signal: DBI_CSX_AB, pin_signal: PIO2_0, direction: OUTPUT, slew_rate: standard, input_buffer: disable, pull_select: up,
    pull_enable: disable}
  - {pin_num: G2, peripheral: LCDIF, signal: DBI_DCX_AB, pin_signal: PIO2_1, direction: OUTPUT, slew_rate: slow, input_buffer: disable, pull_select: up,
    pull_enable: disable}
 * BE CAREFUL MODIFYING THIS COMMENT - IT IS YAML SETTINGS FOR TOOLS ***********
 */
/* clang-format on */

/* FUNCTION ************************************************************************************************************
 *
 * Function Name : BOARD_InitLcdDBIPanelPins
 * Description   : Configures pin routing and optionally pin electrical features.
 *
 * END ****************************************************************************************************************/
/* Function assigned for the Cortex-M33 (Core #0) */
void BOARD_InitLcdDBIPanelPins(void)
{

    GPIO2->PDDR = ((GPIO2->PDDR &
                    /* Mask bits to zero which are setting */
                    (~(GPIO_PDDR_PDD15_MASK)))

                   /* Port Data Direction: Pin is configured as general-purpose output for the GPIO function. */
                   | GPIO_PDDR_PDD15(PDDR_PDD15_pdd1));

    const uint32_t port2_pin0_config = (/* Pin is configured as LCDIF_DBI_CSX_AB */
                                        IOPCTL_PIO_FUNC7 |
                                        /* Disable pull-up / pull-down function */
                                        IOPCTL_PIO_PUPD_DI |
                                        /* Enable pull-up function */
                                        IOPCTL_PIO_PULLUP_EN |
                                        /* Disable input buffer function */
                                        IOPCTL_PIO_INBUF_DI |
                                        /* Normal mode */
                                        IOPCTL_PIO_SLEW_RATE_NORMAL |
                                        /* Normal drive */
                                        IOPCTL_PIO_FULLDRIVE_DI |
                                        /* Analog mux is disabled */
                                        IOPCTL_PIO_ANAMUX_DI |
                                        /* Pseudo Output Drain is disabled */
                                        IOPCTL_PIO_PSEDRAIN_DI |
                                        /* Input function is not inverted */
                                        IOPCTL_PIO_INV_DI);
    /* PORT2 PIN0 (coords: H2) is configured as LCDIF_DBI_CSX_AB */
    IOPCTL_PinMuxSet(2U, 0U, port2_pin0_config);

    const uint32_t port2_pin1_config = (/* Pin is configured as LCDIF_DBI_DCX_AB */
                                        IOPCTL_PIO_FUNC7 |
                                        /* Disable pull-up / pull-down function */
                                        IOPCTL_PIO_PUPD_DI |
                                        /* Enable pull-up function */
                                        IOPCTL_PIO_PULLUP_EN |
                                        /* Disable input buffer function */
                                        IOPCTL_PIO_INBUF_DI |
                                        /* Slow mode */
                                        IOPCTL_PIO_SLEW_RATE_SLOW |
                                        /* Normal drive */
                                        IOPCTL_PIO_FULLDRIVE_DI |
                                        /* Analog mux is disabled */
                                        IOPCTL_PIO_ANAMUX_DI |
                                        /* Pseudo Output Drain is disabled */
                                        IOPCTL_PIO_PSEDRAIN_DI |
                                        /* Input function is not inverted */
                                        IOPCTL_PIO_INV_DI);
    /* PORT2 PIN1 (coords: G2) is configured as LCDIF_DBI_DCX_AB */
    IOPCTL_PinMuxSet(2U, 1U, port2_pin1_config);

    const uint32_t port2_pin15_config = (/* Pin is configured as GPIO2_IO15 */
                                         IOPCTL_PIO_FUNC0 |
                                         /* Disable pull-up / pull-down function */
                                         IOPCTL_PIO_PUPD_DI |
                                         /* Enable pull-down function */
                                         IOPCTL_PIO_PULLDOWN_EN |
                                         /* Disable input buffer function */
                                         IOPCTL_PIO_INBUF_DI |
                                         /* Normal mode */
                                         IOPCTL_PIO_SLEW_RATE_NORMAL |
                                         /* Normal drive */
                                         IOPCTL_PIO_FULLDRIVE_DI |
                                         /* Analog mux is disabled */
                                         IOPCTL_PIO_ANAMUX_DI |
                                         /* Pseudo Output Drain is disabled */
                                         IOPCTL_PIO_PSEDRAIN_DI |
                                         /* Input function is not inverted */
                                         IOPCTL_PIO_INV_DI);
    /* PORT2 PIN15 (coords: D3) is configured as GPIO2_IO15 */
    IOPCTL_PinMuxSet(2U, 15U, port2_pin15_config);

    const uint32_t port2_pin3_config = (/* Pin is configured as LCDIF_DBI_RWDX */
                                        IOPCTL_PIO_FUNC7 |
                                        /* Disable pull-up / pull-down function */
                                        IOPCTL_PIO_PUPD_DI |
                                        /* Enable pull-up function */
                                        IOPCTL_PIO_PULLUP_EN |
                                        /* Disable input buffer function */
                                        IOPCTL_PIO_INBUF_DI |
                                        /* Slow mode */
                                        IOPCTL_PIO_SLEW_RATE_SLOW |
                                        /* Normal drive */
                                        IOPCTL_PIO_FULLDRIVE_DI |
                                        /* Analog mux is disabled */
                                        IOPCTL_PIO_ANAMUX_DI |
                                        /* Pseudo Output Drain is disabled */
                                        IOPCTL_PIO_PSEDRAIN_DI |
                                        /* Input function is not inverted */
                                        IOPCTL_PIO_INV_DI);
    /* PORT2 PIN3 (coords: G1) is configured as LCDIF_DBI_RWDX */
    IOPCTL_PinMuxSet(2U, 3U, port2_pin3_config);

    const uint32_t port2_pin4_config = (/* Pin is configured as LCDIF_DBI_WRX */
                                        IOPCTL_PIO_FUNC7 |
                                        /* Disable pull-up / pull-down function */
                                        IOPCTL_PIO_PUPD_DI |
                                        /* Enable pull-up function */
                                        IOPCTL_PIO_PULLUP_EN |
                                        /* Disable input buffer function */
                                        IOPCTL_PIO_INBUF_DI |
                                        /* Normal mode */
                                        IOPCTL_PIO_SLEW_RATE_NORMAL |
                                        /* Normal drive */
                                        IOPCTL_PIO_FULLDRIVE_DI |
                                        /* Analog mux is disabled */
                                        IOPCTL_PIO_ANAMUX_DI |
                                        /* Pseudo Output Drain is disabled */
                                        IOPCTL_PIO_PSEDRAIN_DI |
                                        /* Input function is not inverted */
                                        IOPCTL_PIO_INV_DI);
    /* PORT2 PIN4 (coords: G3) is configured as LCDIF_DBI_WRX */
    IOPCTL_PinMuxSet(2U, 4U, port2_pin4_config);

    const uint32_t port2_pin6_config = (/* Pin is configured as LCDIF_DBI_DATA0 */
                                        IOPCTL_PIO_FUNC7 |
                                        /* Enable pull-up / pull-down function */
                                        IOPCTL_PIO_PUPD_EN |
                                        /* Enable pull-up function */
                                        IOPCTL_PIO_PULLUP_EN |
                                        /* Disable input buffer function */
                                        IOPCTL_PIO_INBUF_DI |
                                        /* Normal mode */
                                        IOPCTL_PIO_SLEW_RATE_NORMAL |
                                        /* Normal drive */
                                        IOPCTL_PIO_FULLDRIVE_DI |
                                        /* Analog mux is disabled */
                                        IOPCTL_PIO_ANAMUX_DI |
                                        /* Pseudo Output Drain is disabled */
                                        IOPCTL_PIO_PSEDRAIN_DI |
                                        /* Input function is not inverted */
                                        IOPCTL_PIO_INV_DI);
    /* PORT2 PIN6 (coords: H6) is configured as LCDIF_DBI_DATA0 */
    IOPCTL_PinMuxSet(2U, 6U, port2_pin6_config);

    const uint32_t port2_pin7_config = (/* Pin is configured as LCDIF_DBI_DATA1 */
                                        IOPCTL_PIO_FUNC7 |
                                        /* Enable pull-up / pull-down function */
                                        IOPCTL_PIO_PUPD_EN |
                                        /* Enable pull-up function */
                                        IOPCTL_PIO_PULLUP_EN |
                                        /* Disable input buffer function */
                                        IOPCTL_PIO_INBUF_DI |
                                        /* Normal mode */
                                        IOPCTL_PIO_SLEW_RATE_NORMAL |
                                        /* Normal drive */
                                        IOPCTL_PIO_FULLDRIVE_DI |
                                        /* Analog mux is disabled */
                                        IOPCTL_PIO_ANAMUX_DI |
                                        /* Pseudo Output Drain is disabled */
                                        IOPCTL_PIO_PSEDRAIN_DI |
                                        /* Input function is not inverted */
                                        IOPCTL_PIO_INV_DI);
    /* PORT2 PIN7 (coords: G6) is configured as LCDIF_DBI_DATA1 */
    IOPCTL_PinMuxSet(2U, 7U, port2_pin7_config);

    const uint32_t port2_pin8_config = (/* Pin is configured as LCDIF_DBI_DATA2 */
                                        IOPCTL_PIO_FUNC7 |
                                        /* Enable pull-up / pull-down function */
                                        IOPCTL_PIO_PUPD_EN |
                                        /* Enable pull-up function */
                                        IOPCTL_PIO_PULLUP_EN |
                                        /* Disable input buffer function */
                                        IOPCTL_PIO_INBUF_DI |
                                        /* Normal mode */
                                        IOPCTL_PIO_SLEW_RATE_NORMAL |
                                        /* Normal drive */
                                        IOPCTL_PIO_FULLDRIVE_DI |
                                        /* Analog mux is disabled */
                                        IOPCTL_PIO_ANAMUX_DI |
                                        /* Pseudo Output Drain is disabled */
                                        IOPCTL_PIO_PSEDRAIN_DI |
                                        /* Input function is not inverted */
                                        IOPCTL_PIO_INV_DI);
    /* PORT2 PIN8 (coords: G4) is configured as LCDIF_DBI_DATA2 */
    IOPCTL_PinMuxSet(2U, 8U, port2_pin8_config);

    const uint32_t port2_pin9_config = (/* Pin is configured as LCDIF_DBI_DATA3 */
                                        IOPCTL_PIO_FUNC7 |
                                        /* Enable pull-up / pull-down function */
                                        IOPCTL_PIO_PUPD_EN |
                                        /* Enable pull-up function */
                                        IOPCTL_PIO_PULLUP_EN |
                                        /* Disable input buffer function */
                                        IOPCTL_PIO_INBUF_DI |
                                        /* Normal mode */
                                        IOPCTL_PIO_SLEW_RATE_NORMAL |
                                        /* Normal drive */
                                        IOPCTL_PIO_FULLDRIVE_DI |
                                        /* Analog mux is disabled */
                                        IOPCTL_PIO_ANAMUX_DI |
                                        /* Pseudo Output Drain is disabled */
                                        IOPCTL_PIO_PSEDRAIN_DI |
                                        /* Input function is not inverted */
                                        IOPCTL_PIO_INV_DI);
    /* PORT2 PIN9 (coords: G5) is configured as LCDIF_DBI_DATA3 */
    IOPCTL_PinMuxSet(2U, 9U, port2_pin9_config);

    const uint32_t port2_pin10_config = (/* Pin is configured as LCDIF_DBI_DATA4 */
                                         IOPCTL_PIO_FUNC7 |
                                         /* Enable pull-up / pull-down function */
                                         IOPCTL_PIO_PUPD_EN |
                                         /* Enable pull-up function */
                                         IOPCTL_PIO_PULLUP_EN |
                                         /* Disable input buffer function */
                                         IOPCTL_PIO_INBUF_DI |
                                         /* Normal mode */
                                         IOPCTL_PIO_SLEW_RATE_NORMAL |
                                         /* Normal drive */
                                         IOPCTL_PIO_FULLDRIVE_DI |
                                         /* Analog mux is disabled */
                                         IOPCTL_PIO_ANAMUX_DI |
                                         /* Pseudo Output Drain is disabled */
                                         IOPCTL_PIO_PSEDRAIN_DI |
                                         /* Input function is not inverted */
                                         IOPCTL_PIO_INV_DI);
    /* PORT2 PIN10 (coords: F5) is configured as LCDIF_DBI_DATA4 */
    IOPCTL_PinMuxSet(2U, 10U, port2_pin10_config);

    const uint32_t port2_pin11_config = (/* Pin is configured as LCDIF_DBI_DATA5 */
                                         IOPCTL_PIO_FUNC7 |
                                         /* Enable pull-up / pull-down function */
                                         IOPCTL_PIO_PUPD_EN |
                                         /* Enable pull-up function */
                                         IOPCTL_PIO_PULLUP_EN |
                                         /* Disable input buffer function */
                                         IOPCTL_PIO_INBUF_DI |
                                         /* Normal mode */
                                         IOPCTL_PIO_SLEW_RATE_NORMAL |
                                         /* Normal drive */
                                         IOPCTL_PIO_FULLDRIVE_DI |
                                         /* Analog mux is disabled */
                                         IOPCTL_PIO_ANAMUX_DI |
                                         /* Pseudo Output Drain is disabled */
                                         IOPCTL_PIO_PSEDRAIN_DI |
                                         /* Input function is not inverted */
                                         IOPCTL_PIO_INV_DI);
    /* PORT2 PIN11 (coords: F3) is configured as LCDIF_DBI_DATA5 */
    IOPCTL_PinMuxSet(2U, 11U, port2_pin11_config);

    const uint32_t port2_pin12_config = (/* Pin is configured as LCDIF_DBI_DATA6 */
                                         IOPCTL_PIO_FUNC7 |
                                         /* Enable pull-up / pull-down function */
                                         IOPCTL_PIO_PUPD_EN |
                                         /* Enable pull-up function */
                                         IOPCTL_PIO_PULLUP_EN |
                                         /* Disable input buffer function */
                                         IOPCTL_PIO_INBUF_DI |
                                         /* Normal mode */
                                         IOPCTL_PIO_SLEW_RATE_NORMAL |
                                         /* Normal drive */
                                         IOPCTL_PIO_FULLDRIVE_DI |
                                         /* Analog mux is disabled */
                                         IOPCTL_PIO_ANAMUX_DI |
                                         /* Pseudo Output Drain is disabled */
                                         IOPCTL_PIO_PSEDRAIN_DI |
                                         /* Input function is not inverted */
                                         IOPCTL_PIO_INV_DI);
    /* PORT2 PIN12 (coords: E3) is configured as LCDIF_DBI_DATA6 */
    IOPCTL_PinMuxSet(2U, 12U, port2_pin12_config);

    const uint32_t port2_pin13_config = (/* Pin is configured as LCDIF_DBI_DATA7 */
                                         IOPCTL_PIO_FUNC7 |
                                         /* Enable pull-up / pull-down function */
                                         IOPCTL_PIO_PUPD_EN |
                                         /* Enable pull-up function */
                                         IOPCTL_PIO_PULLUP_EN |
                                         /* Disable input buffer function */
                                         IOPCTL_PIO_INBUF_DI |
                                         /* Normal mode */
                                         IOPCTL_PIO_SLEW_RATE_NORMAL |
                                         /* Normal drive */
                                         IOPCTL_PIO_FULLDRIVE_DI |
                                         /* Analog mux is disabled */
                                         IOPCTL_PIO_ANAMUX_DI |
                                         /* Pseudo Output Drain is disabled */
                                         IOPCTL_PIO_PSEDRAIN_DI |
                                         /* Input function is not inverted */
                                         IOPCTL_PIO_INV_DI);
    /* PORT2 PIN13 (coords: E4) is configured as LCDIF_DBI_DATA7 */
    IOPCTL_PinMuxSet(2U, 13U, port2_pin13_config);
}

/* clang-format off */
/*
 * TEXT BELOW IS USED AS SETTING FOR TOOLS *************************************
BOARD_InitPins:
- options: {callFromInitBoot: 'true', coreID: cm33_core0, enableClock: 'true'}
- pin_list:
  - {pin_num: J5, peripheral: LP_FLEXCOMM8, signal: P0, pin_signal: PIO0_6, open_drain: enable, input_buffer: enable}
  - {pin_num: K5, peripheral: LP_FLEXCOMM8, signal: P1, pin_signal: PIO0_7, open_drain: enable, input_buffer: enable}
 * BE CAREFUL MODIFYING THIS COMMENT - IT IS YAML SETTINGS FOR TOOLS ***********
 */
/* clang-format on */

/* FUNCTION ************************************************************************************************************
 *
 * Function Name : BOARD_InitPins
 * Description   : Configures pin routing and optionally pin electrical features.
 *
 * END ****************************************************************************************************************/
/* Function assigned for the Cortex-M33 (Core #0) */
void BOARD_InitI2cPins(void)
{
    const uint32_t port0_pin6_config = (/* Pin is configured as LP_FLEXCOMM8_P0 */
                                        IOPCTL_PIO_FUNC5 |
                                        /* Enable pull-up / pull-down function */
                                        IOPCTL_PIO_PUPD_EN |
                                        /* Enable pull-up function */
                                        IOPCTL_PIO_PULLUP_EN |
                                        /* Enables input buffer function */
                                        IOPCTL_PIO_INBUF_EN |
                                        /* Normal mode */
                                        IOPCTL_PIO_SLEW_RATE_NORMAL |
                                        /* Normal drive */
                                        IOPCTL_PIO_FULLDRIVE_DI |
                                        /* Analog mux is disabled */
                                        IOPCTL_PIO_ANAMUX_DI |
                                        /* Pseudo Output Drain is enabled */
                                        IOPCTL_PIO_PSEDRAIN_EN |
                                        /* Input function is not inverted */
                                        IOPCTL_PIO_INV_DI);
    /* PORT0 PIN6 (coords: J5) is configured as LP_FLEXCOMM8_P0 */
    IOPCTL_PinMuxSet(0U, 6U, port0_pin6_config);

    const uint32_t port0_pin7_config = (/* Pin is configured as LP_FLEXCOMM8_P1 */
                                        IOPCTL_PIO_FUNC5 |
                                        /* Enable pull-up / pull-down function */
                                        IOPCTL_PIO_PUPD_EN |
                                        /* Enable pull-down function */
                                        IOPCTL_PIO_PULLDOWN_EN |
                                        /* Enables input buffer function */
                                        IOPCTL_PIO_INBUF_EN |
                                        /* Normal mode */
                                        IOPCTL_PIO_SLEW_RATE_NORMAL |
                                        /* Normal drive */
                                        IOPCTL_PIO_FULLDRIVE_DI |
                                        /* Analog mux is disabled */
                                        IOPCTL_PIO_ANAMUX_DI |
                                        /* Pseudo Output Drain is enabled */
                                        IOPCTL_PIO_PSEDRAIN_EN |
                                        /* Input function is not inverted */
                                        IOPCTL_PIO_INV_DI);
    /* PORT0 PIN7 (coords: K5) is configured as LP_FLEXCOMM8_P1 */
    IOPCTL_PinMuxSet(0U, 7U, port0_pin7_config);
}

/* FUNCTION ************************************************************************************************************
 *
 * Function Name : BOARD_InitPsRamPins_Xspi2
 * Description   : Configures pin routing and optionally pin electrical features.
 *
 * END ****************************************************************************************************************/
/* Function assigned for the Cortex-M33 */
void BOARD_InitPsRamPins_Xspi2(void)
{

    RESET_ClearPeripheralReset(kIOPCTL2_RST_SHIFT_RSTn);

    const uint32_t port4_pin0_config = (
                                        IOPCTL_PIO_FUNC1 |
                                        /* Disable pull-up / pull-down function */
                                        IOPCTL_PIO_PUPD_DI |
                                        /* Enable pull-down function */
                                        IOPCTL_PIO_PULLDOWN_EN |
                                        /* Disable input buffer function */
                                        IOPCTL_PIO_INBUF_EN |
                                        /* Normal mode */
                                        IOPCTL_PIO_SLEW_RATE_NORMAL |
                                        /* Normal drive */
                                        IOPCTL_PIO_DRIVE_100OHM |
                                        /* Analog mux is disabled */
                                        IOPCTL_PIO_ANAMUX_DI |
                                        /* Pseudo Output Drain is disabled */
                                        IOPCTL_PIO_PSEDRAIN_DI |
                                        /* Input function is not inverted */
                                        IOPCTL_PIO_INV_DI);

    IOPCTL_PinMuxSet(4U, 0U, port4_pin0_config);

    const uint32_t port4_pin1_config = (
                                        IOPCTL_PIO_FUNC1 |
                                        /* Disable pull-up / pull-down function */
                                        IOPCTL_PIO_PUPD_DI |
                                        /* Enable pull-down function */
                                        IOPCTL_PIO_PULLDOWN_EN |
                                        /* Disable input buffer function */
                                        IOPCTL_PIO_INBUF_EN |
                                        /* Normal mode */
                                        IOPCTL_PIO_SLEW_RATE_NORMAL |
                                        /* Normal drive */
                                        IOPCTL_PIO_DRIVE_100OHM |
                                        /* Analog mux is disabled */
                                        IOPCTL_PIO_ANAMUX_DI |
                                        /* Pseudo Output Drain is disabled */
                                        IOPCTL_PIO_PSEDRAIN_DI |
                                        /* Input function is not inverted */
                                        IOPCTL_PIO_INV_DI);

    IOPCTL_PinMuxSet(4U, 1U, port4_pin1_config);

    const uint32_t port4_pin2_config = (
                                        IOPCTL_PIO_FUNC1 |
                                        /* Disable pull-up / pull-down function */
                                        IOPCTL_PIO_PUPD_DI |
                                        /* Enable pull-down function */
                                        IOPCTL_PIO_PULLDOWN_EN |
                                        /* Disable input buffer function */
                                        IOPCTL_PIO_INBUF_EN |
                                        /* Normal mode */
                                        IOPCTL_PIO_SLEW_RATE_NORMAL |
                                        /* Normal drive */
                                        IOPCTL_PIO_DRIVE_100OHM |
                                        /* Analog mux is disabled */
                                        IOPCTL_PIO_ANAMUX_DI |
                                        /* Pseudo Output Drain is disabled */
                                        IOPCTL_PIO_PSEDRAIN_DI |
                                        /* Input function is not inverted */
                                        IOPCTL_PIO_INV_DI);

    IOPCTL_PinMuxSet(4U, 2U, port4_pin2_config);

    const uint32_t port4_pin3_config = (
                                        IOPCTL_PIO_FUNC1 |
                                        /* Disable pull-up / pull-down function */
                                        IOPCTL_PIO_PUPD_DI |
                                        /* Enable pull-down function */
                                        IOPCTL_PIO_PULLDOWN_EN |
                                        /* Disable input buffer function */
                                        IOPCTL_PIO_INBUF_EN |
                                        /* Normal mode */
                                        IOPCTL_PIO_SLEW_RATE_NORMAL |
                                        /* Normal drive */
                                        IOPCTL_PIO_DRIVE_100OHM |
                                        /* Analog mux is disabled */
                                        IOPCTL_PIO_ANAMUX_DI |
                                        /* Pseudo Output Drain is disabled */
                                        IOPCTL_PIO_PSEDRAIN_DI |
                                        /* Input function is not inverted */
                                        IOPCTL_PIO_INV_DI);

    IOPCTL_PinMuxSet(4U, 3U, port4_pin3_config);

    const uint32_t port4_pin4_config = (
                                        IOPCTL_PIO_FUNC1 |
                                        /* Disable pull-up / pull-down function */
                                        IOPCTL_PIO_PUPD_DI |
                                        /* Enable pull-down function */
                                        IOPCTL_PIO_PULLDOWN_EN |
                                        /* Disable input buffer function */
                                        IOPCTL_PIO_INBUF_EN |
                                        /* Normal mode */
                                        IOPCTL_PIO_SLEW_RATE_NORMAL |
                                        /* Normal drive */
                                        IOPCTL_PIO_DRIVE_100OHM |
                                        /* Analog mux is disabled */
                                        IOPCTL_PIO_ANAMUX_DI |
                                        /* Pseudo Output Drain is disabled */
                                        IOPCTL_PIO_PSEDRAIN_DI |
                                        /* Input function is not inverted */
                                        IOPCTL_PIO_INV_DI);

    IOPCTL_PinMuxSet(4U, 4U, port4_pin4_config);

    const uint32_t port4_pin5_config = (
                                        IOPCTL_PIO_FUNC1 |
                                        /* Disable pull-up / pull-down function */
                                        IOPCTL_PIO_PUPD_DI |
                                        /* Enable pull-down function */
                                        IOPCTL_PIO_PULLDOWN_EN |
                                        /* Disable input buffer function */
                                        IOPCTL_PIO_INBUF_EN |
                                        /* Normal mode */
                                        IOPCTL_PIO_SLEW_RATE_NORMAL |
                                        /* Normal drive */
                                        IOPCTL_PIO_DRIVE_100OHM |
                                        /* Analog mux is disabled */
                                        IOPCTL_PIO_ANAMUX_DI |
                                        /* Pseudo Output Drain is disabled */
                                        IOPCTL_PIO_PSEDRAIN_DI |
                                        /* Input function is not inverted */
                                        IOPCTL_PIO_INV_DI);

    IOPCTL_PinMuxSet(4U, 5U, port4_pin5_config);

    const uint32_t port4_pin6_config = (
                                        IOPCTL_PIO_FUNC1 |
                                        /* Disable pull-up / pull-down function */
                                        IOPCTL_PIO_PUPD_DI |
                                        /* Enable pull-down function */
                                        IOPCTL_PIO_PULLDOWN_EN |
                                        /* Disable input buffer function */
                                        IOPCTL_PIO_INBUF_EN |
                                        /* Normal mode */
                                        IOPCTL_PIO_SLEW_RATE_NORMAL |
                                        /* Normal drive */
                                        IOPCTL_PIO_DRIVE_100OHM |
                                        /* Analog mux is disabled */
                                        IOPCTL_PIO_ANAMUX_DI |
                                        /* Pseudo Output Drain is disabled */
                                        IOPCTL_PIO_PSEDRAIN_DI |
                                        /* Input function is not inverted */
                                        IOPCTL_PIO_INV_DI);

    IOPCTL_PinMuxSet(4U, 6U, port4_pin6_config);

    const uint32_t port4_pin7_config = (
                                        IOPCTL_PIO_FUNC1 |
                                        /* Disable pull-up / pull-down function */
                                        IOPCTL_PIO_PUPD_DI |
                                        /* Enable pull-down function */
                                        IOPCTL_PIO_PULLDOWN_EN |
                                        /* Disable input buffer function */
                                        IOPCTL_PIO_INBUF_EN |
                                        /* Normal mode */
                                        IOPCTL_PIO_SLEW_RATE_NORMAL |
                                        /* Normal drive */
                                        IOPCTL_PIO_DRIVE_100OHM |
                                        /* Analog mux is disabled */
                                        IOPCTL_PIO_ANAMUX_DI |
                                        /* Pseudo Output Drain is disabled */
                                        IOPCTL_PIO_PSEDRAIN_DI |
                                        /* Input function is not inverted */
                                        IOPCTL_PIO_INV_DI);

    IOPCTL_PinMuxSet(4U, 7U, port4_pin7_config);

    const uint32_t port4_pin8_config = (
                                        IOPCTL_PIO_FUNC1 |
                                        /* Disable pull-up / pull-down function */
                                        IOPCTL_PIO_PUPD_DI |
                                        /* Enable pull-down function */
                                        IOPCTL_PIO_PULLDOWN_EN |
                                        /* Disable input buffer function */
                                        IOPCTL_PIO_INBUF_EN |
                                        /* Normal mode */
                                        IOPCTL_PIO_SLEW_RATE_NORMAL |
                                        /* Normal drive */
                                        IOPCTL_PIO_DRIVE_100OHM |
                                        /* Analog mux is disabled */
                                        IOPCTL_PIO_ANAMUX_DI |
                                        /* Pseudo Output Drain is disabled */
                                        IOPCTL_PIO_PSEDRAIN_DI |
                                        /* Input function is not inverted */
                                        IOPCTL_PIO_INV_DI);

    IOPCTL_PinMuxSet(4U, 8U, port4_pin8_config);

    const uint32_t port4_pin9_config = (
                                        IOPCTL_PIO_FUNC1 |
                                        /* Disable pull-up / pull-down function */
                                        IOPCTL_PIO_PUPD_DI |
                                        /* Enable pull-down function */
                                        IOPCTL_PIO_PULLDOWN_EN |
                                        /* Disable input buffer function */
                                        IOPCTL_PIO_INBUF_EN |
                                        /* Normal mode */
                                        IOPCTL_PIO_SLEW_RATE_NORMAL |
                                        /* Normal drive */
                                        IOPCTL_PIO_DRIVE_100OHM |
                                        /* Analog mux is disabled */
                                        IOPCTL_PIO_ANAMUX_DI |
                                        /* Pseudo Output Drain is disabled */
                                        IOPCTL_PIO_PSEDRAIN_DI |
                                        /* Input function is not inverted */
                                        IOPCTL_PIO_INV_DI);

    IOPCTL_PinMuxSet(4U, 9U, port4_pin9_config);

    const uint32_t port4_pin10_config = (
                                        IOPCTL_PIO_FUNC1 |
                                        /* Disable pull-up / pull-down function */
                                        IOPCTL_PIO_PUPD_DI |
                                        /* Enable pull-down function */
                                        IOPCTL_PIO_PULLDOWN_EN |
                                        /* Disable input buffer function */
                                        IOPCTL_PIO_INBUF_EN |
                                        /* Normal mode */
                                        IOPCTL_PIO_SLEW_RATE_NORMAL |
                                        /* Normal drive */
                                        IOPCTL_PIO_DRIVE_100OHM |
                                        /* Analog mux is disabled */
                                        IOPCTL_PIO_ANAMUX_DI |
                                        /* Pseudo Output Drain is disabled */
                                        IOPCTL_PIO_PSEDRAIN_DI |
                                        /* Input function is not inverted */
                                        IOPCTL_PIO_INV_DI);

    IOPCTL_PinMuxSet(4U, 10U, port4_pin10_config);

    const uint32_t port4_pin11_config = (
                                        IOPCTL_PIO_FUNC1 |
                                        /* Disable pull-up / pull-down function */
                                        IOPCTL_PIO_PUPD_DI |
                                        /* Enable pull-down function */
                                        IOPCTL_PIO_PULLDOWN_EN |
                                        /* Disable input buffer function */
                                        IOPCTL_PIO_INBUF_EN |
                                        /* Normal mode */
                                        IOPCTL_PIO_SLEW_RATE_NORMAL |
                                        /* Normal drive */
                                        IOPCTL_PIO_DRIVE_100OHM |
                                        /* Analog mux is disabled */
                                        IOPCTL_PIO_ANAMUX_DI |
                                        /* Pseudo Output Drain is disabled */
                                        IOPCTL_PIO_PSEDRAIN_DI |
                                        /* Input function is not inverted */
                                        IOPCTL_PIO_INV_DI);

    IOPCTL_PinMuxSet(4U, 11U, port4_pin11_config);

    const uint32_t port4_pin12_config = (
                                        IOPCTL_PIO_FUNC1 |
                                        /* Disable pull-up / pull-down function */
                                        IOPCTL_PIO_PUPD_DI |
                                        /* Enable pull-down function */
                                        IOPCTL_PIO_PULLDOWN_EN |
                                        /* Disable input buffer function */
                                        IOPCTL_PIO_INBUF_EN |
                                        /* Normal mode */
                                        IOPCTL_PIO_SLEW_RATE_NORMAL |
                                        /* Normal drive */
                                        IOPCTL_PIO_DRIVE_100OHM |
                                        /* Analog mux is disabled */
                                        IOPCTL_PIO_ANAMUX_DI |
                                        /* Pseudo Output Drain is disabled */
                                        IOPCTL_PIO_PSEDRAIN_DI |
                                        /* Input function is not inverted */
                                        IOPCTL_PIO_INV_DI);

    IOPCTL_PinMuxSet(4U, 12U, port4_pin12_config);

    const uint32_t port4_pin13_config = (
                                        IOPCTL_PIO_FUNC1 |
                                        /* Disable pull-up / pull-down function */
                                        IOPCTL_PIO_PUPD_DI |
                                        /* Enable pull-down function */
                                        IOPCTL_PIO_PULLDOWN_EN |
                                        /* Disable input buffer function */
                                        IOPCTL_PIO_INBUF_EN |
                                        /* Normal mode */
                                        IOPCTL_PIO_SLEW_RATE_NORMAL |
                                        /* Normal drive */
                                        IOPCTL_PIO_DRIVE_100OHM |
                                        /* Analog mux is disabled */
                                        IOPCTL_PIO_ANAMUX_DI |
                                        /* Pseudo Output Drain is disabled */
                                        IOPCTL_PIO_PSEDRAIN_DI |
                                        /* Input function is not inverted */
                                        IOPCTL_PIO_INV_DI);

    IOPCTL_PinMuxSet(4U, 13U, port4_pin13_config);

    const uint32_t port4_pin14_config = (
                                        IOPCTL_PIO_FUNC1 |
                                        /* Disable pull-up / pull-down function */
                                        IOPCTL_PIO_PUPD_DI |
                                        /* Enable pull-down function */
                                        IOPCTL_PIO_PULLDOWN_EN |
                                        /* Disable input buffer function */
                                        IOPCTL_PIO_INBUF_EN |
                                        /* Normal mode */
                                        IOPCTL_PIO_SLEW_RATE_NORMAL |
                                        /* Normal drive */
                                        IOPCTL_PIO_DRIVE_100OHM |
                                        /* Analog mux is disabled */
                                        IOPCTL_PIO_ANAMUX_DI |
                                        /* Pseudo Output Drain is disabled */
                                        IOPCTL_PIO_PSEDRAIN_DI |
                                        /* Input function is not inverted */
                                        IOPCTL_PIO_INV_DI);

    IOPCTL_PinMuxSet(4U, 14U, port4_pin14_config);

    const uint32_t port4_pin15_config = (
                                        IOPCTL_PIO_FUNC1 |
                                        /* Disable pull-up / pull-down function */
                                        IOPCTL_PIO_PUPD_DI |
                                        /* Enable pull-down function */
                                        IOPCTL_PIO_PULLDOWN_EN |
                                        /* Disable input buffer function */
                                        IOPCTL_PIO_INBUF_EN |
                                        /* Normal mode */
                                        IOPCTL_PIO_SLEW_RATE_NORMAL |
                                        /* Normal drive */
                                        IOPCTL_PIO_DRIVE_100OHM |
                                        /* Analog mux is disabled */
                                        IOPCTL_PIO_ANAMUX_DI |
                                        /* Pseudo Output Drain is disabled */
                                        IOPCTL_PIO_PSEDRAIN_DI |
                                        /* Input function is not inverted */
                                        IOPCTL_PIO_INV_DI);

    IOPCTL_PinMuxSet(4U, 15U, port4_pin15_config);

    const uint32_t port4_pin16_config = (
                                        IOPCTL_PIO_FUNC1 |
                                        /* Disable pull-up / pull-down function */
                                        IOPCTL_PIO_PUPD_DI |
                                        /* Enable pull-down function */
                                        IOPCTL_PIO_PULLDOWN_EN |
                                        /* Disable input buffer function */
                                        IOPCTL_PIO_INBUF_EN |
                                        /* Normal mode */
                                        IOPCTL_PIO_SLEW_RATE_NORMAL |
                                        /* Normal drive */
                                        IOPCTL_PIO_DRIVE_100OHM |
                                        /* Analog mux is disabled */
                                        IOPCTL_PIO_ANAMUX_DI |
                                        /* Pseudo Output Drain is disabled */
                                        IOPCTL_PIO_PSEDRAIN_DI |
                                        /* Input function is not inverted */
                                        IOPCTL_PIO_INV_DI);

    IOPCTL_PinMuxSet(4U, 16U, port4_pin16_config);

    const uint32_t port4_pin17_config = (
                                        IOPCTL_PIO_FUNC1 |
                                        /* Disable pull-up / pull-down function */
                                        IOPCTL_PIO_PUPD_DI |
                                        /* Enable pull-down function */
                                        IOPCTL_PIO_PULLDOWN_EN |
                                        /* Disable input buffer function */
                                        IOPCTL_PIO_INBUF_EN |
                                        /* Normal mode */
                                        IOPCTL_PIO_SLEW_RATE_NORMAL |
                                        /* Normal drive */
                                        IOPCTL_PIO_DRIVE_100OHM |
                                        /* Analog mux is disabled */
                                        IOPCTL_PIO_ANAMUX_DI |
                                        /* Pseudo Output Drain is disabled */
                                        IOPCTL_PIO_PSEDRAIN_DI |
                                        /* Input function is not inverted */
                                        IOPCTL_PIO_INV_DI);

    IOPCTL_PinMuxSet(4U, 17U, port4_pin17_config);

    const uint32_t port4_pin18_config = (
                                        IOPCTL_PIO_FUNC1 |
                                        /* Disable pull-up / pull-down function */
                                        IOPCTL_PIO_PUPD_DI |
                                        /* Enable pull-down function */
                                        IOPCTL_PIO_PULLDOWN_EN |
                                        /* Disable input buffer function */
                                        IOPCTL_PIO_INBUF_EN |
                                        /* Normal mode */
                                        IOPCTL_PIO_SLEW_RATE_NORMAL |
                                        /* Normal drive */
                                        IOPCTL_PIO_DRIVE_100OHM |
                                        /* Analog mux is disabled */
                                        IOPCTL_PIO_ANAMUX_DI |
                                        /* Pseudo Output Drain is disabled */
                                        IOPCTL_PIO_PSEDRAIN_DI |
                                        /* Input function is not inverted */
                                        IOPCTL_PIO_INV_DI);

    IOPCTL_PinMuxSet(4U, 18U, port4_pin18_config);

    const uint32_t port4_pin19_config = (
                                        IOPCTL_PIO_FUNC1 |
                                        /* Disable pull-up / pull-down function */
                                        IOPCTL_PIO_PUPD_DI |
                                        /* Enable pull-down function */
                                        IOPCTL_PIO_PULLDOWN_EN |
                                        /* Disable input buffer function */
                                        IOPCTL_PIO_INBUF_EN |
                                        /* Normal mode */
                                        IOPCTL_PIO_SLEW_RATE_NORMAL |
                                        /* Normal drive */
                                        IOPCTL_PIO_DRIVE_100OHM |
                                        /* Analog mux is disabled */
                                        IOPCTL_PIO_ANAMUX_DI |
                                        /* Pseudo Output Drain is disabled */
                                        IOPCTL_PIO_PSEDRAIN_DI |
                                        /* Input function is not inverted */
                                        IOPCTL_PIO_INV_DI);

    IOPCTL_PinMuxSet(4U, 19U, port4_pin19_config);

    const uint32_t port4_pin20_config = (
                                        IOPCTL_PIO_FUNC1 |
                                        /* Disable pull-up / pull-down function */
                                        IOPCTL_PIO_PUPD_DI |
                                        /* Enable pull-down function */
                                        IOPCTL_PIO_PULLDOWN_EN |
                                        /* Disable input buffer function */
                                        IOPCTL_PIO_INBUF_EN |
                                        /* Normal mode */
                                        IOPCTL_PIO_SLEW_RATE_NORMAL |
                                        /* Normal drive */
                                        IOPCTL_PIO_DRIVE_100OHM |
                                        /* Analog mux is disabled */
                                        IOPCTL_PIO_ANAMUX_DI |
                                        /* Pseudo Output Drain is disabled */
                                        IOPCTL_PIO_PSEDRAIN_DI |
                                        /* Input function is not inverted */
                                        IOPCTL_PIO_INV_DI);

    IOPCTL_PinMuxSet(4U, 20U, port4_pin20_config);
}

/* Function assigned for the Cortex-M33 (Core #0) */
void BOARD_InitPmicPins(void)
{
    /* Reset IOPCTL1 module */
    RESET_ClearPeripheralReset(kIOPCTL1_RST_SHIFT_RSTn);

    IOPCTL1->PMIC_I2C_SCL = ((IOPCTL1->PMIC_I2C_SCL &
                              /* Mask bits to zero which are setting */
                              (~(IOPCTL1_PMIC_I2C_SCL_IBENA_MASK | IOPCTL1_PMIC_I2C_SCL_ODENA_MASK)))

                             /* Input Buffer Enable: Enables */
                             | IOPCTL1_PMIC_I2C_SCL_IBENA(PMIC_I2C_SCL_IBENA_IBENA_1)

                             /* Open-drain Mode Enable: Enables for simulated open-drain output (high drive disabled) */
                             | IOPCTL1_PMIC_I2C_SCL_ODENA(PMIC_I2C_SCL_ODENA_ODENA_1));

    IOPCTL1->PMIC_I2C_SDA = ((IOPCTL1->PMIC_I2C_SDA &
                              /* Mask bits to zero which are setting */
                              (~(IOPCTL1_PMIC_I2C_SDA_IBENA_MASK | IOPCTL1_PMIC_I2C_SDA_ODENA_MASK)))

                             /* Input Buffer Enable: Enables */
                             | IOPCTL1_PMIC_I2C_SDA_IBENA(PMIC_I2C_SDA_IBENA_IBENA_1)

                             /* Open-drain Mode Enable: Enables for simulated open-drain output (high drive disabled) */
                             | IOPCTL1_PMIC_I2C_SDA_ODENA(PMIC_I2C_SDA_ODENA_ODENA_1));
}

/***********************************************************************************************************************
 * EOF
 **********************************************************************************************************************/
