/*
 * Copyright 2024 NXP
 *
 * SPDX-License-Identifier: BSD-3-Clause
 */
/*${header:start}*/
#include "fsl_common.h"
#include "pin_mux.h"
#include "board.h"
#include "app.h"
#include "mcmgr.h"
#include "fsl_cache.h"
#include "pmic_support.h"
/*${header:end}*/

/*******************************************************************************
 * Definitions
 ******************************************************************************/
static status_t BOARD_InitVGliteClock(void)
{
    POWER_DisablePD(kPDRUNCFG_APD_GPU);
    POWER_DisablePD(kPDRUNCFG_PPD_GPU);
    POWER_ApplyPD();

    /* VGPU clock enablement and divider selection */
    CLOCK_EnableClock(kCLOCK_MediaAccessRamArbiter0);
    CLOCK_EnableClock(kCLOCK_MediaAccessRamArbiter1);
    CLOCK_EnableClock(kCLOCK_Gpu);

    CLOCK_AttachClk(kFRO0_DIV1_to_VGPU);
    CLOCK_SetClkDiv(kCLOCK_DivVgpuClk, 1U);

//    /* Enable GPU interrupt */
//    RESET_ClearPeripheralReset(kVGPU_RST_SHIFT_RSTn);
//    NVIC_SetPriority(VGPU_IRQn, 3);
//    EnableIRQ((IRQn_Type)VGPU_IRQn);

    return kStatus_Success;
}

/*${function:start}*/
void BOARD_InitHardware(void)
{
//    BOARD_ConfigMPU();
//    BOARD_InitPins();
//    BOARD_InitBootClocks();
//
//    BOARD_InitDebugConsole();
//
//    BOARD_InitAHBSC();
//
//    /* Powerup all the SRAM partitions. */
//    PMC0->PDRUNCFG2 &= ~0x3FFC0000;
//    PMC0->PDRUNCFG3 &= ~0x3FFC0000;
//
//    POWER_DisablePD(kPDRUNCFG_SHUT_SENSEP_MAINCLK);
//    POWER_ApplyPD();

    BOARD_ConfigMPU();
    BOARD_BootClockRUN();
    BOARD_InitAHBSC();

    BOARD_InitBootPins();
    BOARD_InitPsRamPins_Xspi2();

#ifdef CPU_CLOCK_325_EN
    BOARD_InitPmicPins();
    BOARD_InitPmic();
    BOARD_SetPmicVdd2Voltage(1100000U); /* 1.1v for 325MHz clock. */
    BOARD_SetPmicVdd1Voltage(1100000U); /* 1.1v for 325MHz clock. */
    BOARD_BootClockHSRUN();
#else
    BOARD_BootClockRUN();
#endif

    BOARD_InitDebugConsole();
    BOARD_Init16bitsPsRam(XSPI2);

    /* Disable JPEG decoder power down. */
    POWER_DisablePD(kPDRUNCFG_PPD_JPEGDEC);
    POWER_DisablePD(kPDRUNCFG_APD_JPEGDEC);

    /* Disable NPU power down. */
    POWER_DisablePD(kPDRUNCFG_APD_NPU);
    POWER_DisablePD(kPDRUNCFG_PPD_NPU);

	POWER_DisablePD(kPDRUNCFG_SHUT_SENSEP_MAINCLK);

    POWER_ApplyPD();

    BOARD_InitVGliteClock();
}

#ifdef CORE1_IMAGE_COPY_TO_RAM
uint32_t get_core1_image_size(void)
{
    uint32_t image_size;
#if defined(__CC_ARM) || defined(__ARMCC_VERSION)
    image_size = (uint32_t)&Image$$CORE1_REGION$$Length;
#elif defined(__ICCARM__)
    image_size = (uint32_t)__section_end("__core1_image") - (uint32_t)__section_begin("__core1_image");
#elif defined(__GNUC__)
    image_size = (uint32_t)core1_image_size;
#endif
    return image_size;
}
#endif /* CORE1_IMAGE_COPY_TO_RAM */

#ifdef APP_INVALIDATE_CACHE_FOR_SECONDARY_CORE_IMAGE_MEMORY
void invalidate_cache_for_core1_image_memory(uint32_t address, uint32_t size_byte)
{
    XCACHE_CleanInvalidateCacheByRange(address, size_byte);
}
#endif /* APP_INVALIDATE_CACHE_FOR_SECONDARY_CORE_IMAGE_MEMORY */

/*!
 * @brief Application-specific implementation of the SystemInitHook() weak function.
 */
void SystemInitHook(void)
{
    /* Initialize MCMGR - low level multicore management library. Call this
       function as close to the reset entry as possible to allow CoreUp event
       triggering. The SystemInitHook() weak function overloading is used in this
       application. */
    (void)MCMGR_EarlyInit();
    // MCMGR_TriggerEvent(kMCMGR_RemoteCoreUpEvent, 0);
}
/*${function:end}*/
